"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDataDriftColors = void 0;
var _react = require("react");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useDataDriftColors = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return (0, _react.useMemo)(() => ({
    referenceColor: euiTheme.colors.vis.euiColorVis4,
    comparisonColor: euiTheme.colors.vis.euiColorVis2,
    overlapColor: '#490771'
  }), [euiTheme]);
};
exports.useDataDriftColors = useDataDriftColors;