"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_management/public/components/edit_index_pattern/index_header/index_header.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const setDefaultAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.setDefaultAria', {
  defaultMessage: 'Set as default data view.'
});
const setDefaultTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.setDefaultTooltip', {
  defaultMessage: 'Set as default'
});
const editAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.editAria', {
  defaultMessage: 'Edit data view.'
});
const editTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.editTooltip', {
  defaultMessage: 'Edit data view'
});
const removeAriaLabel = _i18n.i18n.translate('indexPatternManagement.editDataView.removeAria', {
  defaultMessage: 'Delete data view.'
});
const removeTooltip = _i18n.i18n.translate('indexPatternManagement.editDataView.removeTooltip', {
  defaultMessage: 'Delete data view'
});
const IndexHeader = ({
  defaultIndex,
  indexPattern,
  setDefault,
  editIndexPatternClick,
  deleteIndexPatternClick,
  children,
  canSave
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const contextMenuItems = [canSave && indexPattern.isPersisted() && deleteIndexPatternClick && /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    color: "danger",
    onClick: () => {
      setIsOpen(false);
      deleteIndexPatternClick();
    },
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "danger",
      type: "trash",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 15
      }
    }),
    "aria-label": removeAriaLabel,
    "data-test-subj": "deleteIndexPatternButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "danger",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, removeTooltip))].filter(Boolean);
  const renderMoreActionsButton = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: isOpen,
      closePopover: () => setIsOpen(false),
      panelPaddingSize: "none",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "boxesVertical",
        onClick: () => setIsOpen(prevIsOpen => !prevIsOpen),
        size: "m",
        "data-test-subj": "moreActionsButton",
        "aria-label": _i18n.i18n.translate('indexPatternManagement.editDataView.moreActionsButtonAria', {
          defaultMessage: 'More Actions'
        }),
        color: "text",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 98,
          columnNumber: 11
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 93,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      items: contextMenuItems,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: /*#__PURE__*/_react.default.createElement("span", {
      "data-test-subj": "indexPatternTitle",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 18
      }
    }, indexPattern.getName()),
    bottomBorder: true,
    rightSideItems: [canSave && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: editIndexPatternClick,
      iconType: "pencil",
      "aria-label": editAriaLabel,
      "data-test-subj": "editIndexPatternButton",
      color: "primary",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, editTooltip), contextMenuItems.length > 0 && renderMoreActionsButton(), defaultIndex !== indexPattern.id && setDefault && canSave && indexPattern.isPersisted() && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: setDefault,
      iconType: "starEmpty",
      "aria-label": setDefaultAriaLabel,
      "data-test-subj": "setDefaultIndexPatternButton",
      color: "text",
      flush: "both",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 11
      }
    }, setDefaultTooltip)].filter(Boolean),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 5
    }
  }, children);
};
exports.IndexHeader = IndexHeader;