"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDataStreamsRoute = exports.DataStreamsResponseSchema = exports.DataStreamsRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _common = require("../../../common");
var _data_streams_handler = require("./data_streams_handler");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerDataStreamsRoute = (router, dataUsageContext) => {
  router.versioned.get({
    access: 'internal',
    path: _common.DATA_USAGE_DATA_STREAMS_API_ROUTE,
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to scoped ES client'
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: DataStreamsRequestSchema,
      response: {
        200: DataStreamsResponseSchema
      }
    }
  }, (0, _data_streams_handler.getDataStreamsHandler)(dataUsageContext));
};
exports.registerDataStreamsRoute = registerDataStreamsRoute;
const DataStreamsRequestSchema = exports.DataStreamsRequestSchema = {
  query: _configSchema.schema.object({
    includeZeroStorage: _configSchema.schema.boolean({
      defaultValue: false
    })
  })
};
const DataStreamsResponseSchema = exports.DataStreamsResponseSchema = {
  body: () => _configSchema.schema.arrayOf(_configSchema.schema.object({
    name: _configSchema.schema.string(),
    storageSizeBytes: _configSchema.schema.number()
  }))
};