"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetDataUsageMetrics = void 0;
var _reactQuery = require("@kbn/react-query");
var _utils = require("../../common/utils");
var _common = require("../../common");
var _use_kibana = require("../utils/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetDataUsageMetrics = (body, options = {}) => {
  var _momentDateParser, _momentDateParser2;
  const {
    http
  } = (0, _use_kibana.useKibanaContextForPlugin)().services;

  // parse values anyway to ensure they are valid
  // and to avoid sending invalid values to the server
  const from = (_momentDateParser = (0, _utils.momentDateParser)(body.from)) === null || _momentDateParser === void 0 ? void 0 : _momentDateParser.toISOString();
  const to = (_momentDateParser2 = (0, _utils.momentDateParser)(body.to)) === null || _momentDateParser2 === void 0 ? void 0 : _momentDateParser2.toISOString();
  return (0, _reactQuery.useQuery)({
    queryKey: ['get-data-usage-metrics', body],
    ...options,
    enabled: !!(from && to) && options.enabled,
    keepPreviousData: true,
    queryFn: async ({
      signal
    }) => {
      return http.post(_common.DATA_USAGE_METRICS_API_ROUTE, {
        signal,
        version: '1',
        body: JSON.stringify({
          from,
          to,
          metricTypes: body.metricTypes,
          dataStreams: body.dataStreams
        })
      }).catch(error => {
        throw error.body;
      });
    }
  });
};
exports.useGetDataUsageMetrics = useGetDataUsageMetrics;