"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataSourcesRegistryPlugin = void 0;
var _public = require("@kbn/core/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class DataSourcesRegistryPlugin {
  setup(core) {
    const isPluginEnabled = core.settings.client.get('data_sources_registry.enableDataSourcesRegistry',
    // unregistered ff, just to make sure the UI is hidden
    false);
    if (isPluginEnabled) {
      core.application.register({
        id: 'dataSourcesRegistry',
        title: 'Data Sources Registry',
        appRoute: '/app/data-sources-registry',
        category: _public.DEFAULT_APP_CATEGORIES.chat,
        visibleIn: [],
        async mount(params) {
          const {
            renderApp
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
          return renderApp(params);
        }
      });
    }
    return {};
  }
  start(core) {
    return {};
  }
  stop() {}
}
exports.DataSourcesRegistryPlugin = DataSourcesRegistryPlugin;