"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataTableFormat = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _src = require("@kbn/shared-ux-table-persist/src");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data/public/utils/table_inspector_view/components/data_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const PAGE_SIZE_OPTIONS = [10, 20, 50];
class DataTableFormatClass extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "csvSeparator", this.props.uiSettings.get('csv:separator', ','));
    (0, _defineProperty2.default)(this, "quoteValues", this.props.uiSettings.get('csv:quoteValues', true));
    (0, _defineProperty2.default)(this, "state", {});
  }
  static renderCell({
    table,
    columnIndex,
    rowIndex,
    formattedValue,
    uiActions,
    isFilterable
  }) {
    const column = table.columns[columnIndex];
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 9
      }
    }, formattedValue), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "none",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 11
      }
    }, isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.filterForValueButtonTooltip",
        defaultMessage: "Filter for value",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 92,
          columnNumber: 19
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "plusInCircle",
      color: "text",
      "aria-label": _i18n.i18n.translate('data.inspector.table.filterForValueButtonAriaLabel', {
        defaultMessage: 'Filter for value'
      }),
      "data-test-subj": "filterForInspectorCellValue",
      className: "insDataTableFormat__filter",
      onClick: () => {
        const value = table.rows[rowIndex][column.id];
        const eventData = {
          table,
          column: columnIndex,
          row: rowIndex,
          value
        };
        uiActions.executeTriggerActions('VALUE_CLICK_TRIGGER', {
          data: {
            data: [eventData]
          }
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 17
      }
    })), isFilterable && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "bottom",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "data.inspector.table.filterOutValueButtonTooltip",
        defaultMessage: "Filter out value",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 21
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      iconType: "minusInCircle",
      color: "text",
      "aria-label": _i18n.i18n.translate('data.inspector.table.filterOutValueButtonAriaLabel', {
        defaultMessage: 'Filter out value'
      }),
      "data-test-subj": "filterOutInspectorCellValue",
      className: "insDataTableFormat__filter",
      onClick: () => {
        const value = table.rows[rowIndex][column.id];
        const eventData = {
          table,
          column: columnIndex,
          row: rowIndex,
          value
        };
        uiActions.executeTriggerActions('VALUE_CLICK_TRIGGER', {
          data: {
            data: [eventData],
            negate: true
          }
        });
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 19
      }
    }))))));
  }
  static getDerivedStateFromProps({
    data,
    uiActions,
    fieldFormats,
    isFilterable
  }) {
    if (!data) {
      return {
        columns: null,
        rows: null
      };
    }
    const columns = data.columns.map((dataColumn, index) => {
      const formatParams = {
        id: 'string',
        ...dataColumn.meta.params
      };
      const fieldFormatter = fieldFormats.deserialize(formatParams);
      const filterable = isFilterable(dataColumn);
      return {
        name: dataColumn.name,
        field: dataColumn.id,
        sortable: true,
        render: value => {
          const formattedValue = fieldFormatter.convert(value);
          const rowIndex = data.rows.findIndex(row => row[dataColumn.id] === value) || 0;
          return DataTableFormatClass.renderCell({
            table: data,
            columnIndex: index,
            rowIndex,
            formattedValue,
            uiActions,
            isFilterable: filterable
          });
        }
      };
    });
    return {
      columns,
      rows: data.rows
    };
  }
  render() {
    const {
      columns,
      rows
    } = this.state;
    const {
      pageSize,
      sorting,
      onTableChange
    } = this.props.euiTablePersist;
    const pagination = {
      pageSizeOptions: PAGE_SIZE_OPTIONS,
      pageSize
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      tableLayout: "auto",
      className: "insDataTableFormat__table eui-xScroll",
      "data-test-subj": "inspectorTable",
      columns: columns,
      items: rows,
      sorting: sorting,
      pagination: pagination,
      onTableChange: onTableChange,
      css: styles.table,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 7
      }
    });
  }
}
(0, _defineProperty2.default)(DataTableFormatClass, "propTypes", {
  data: _propTypes.default.object.isRequired,
  uiSettings: _propTypes.default.object.isRequired,
  fieldFormats: _propTypes.default.object.isRequired,
  uiActions: _propTypes.default.object.isRequired,
  isFilterable: _propTypes.default.func.isRequired
});
const DataTableFormat = exports.DataTableFormat = (0, _src.withEuiTablePersist)(DataTableFormatClass, {
  tableId: 'inspectorDataTable',
  pageSizeOptions: PAGE_SIZE_OPTIONS,
  initialPageSize: 20
});
const styles = {
  table: (0, _react2.css)({
    // Set a min width on each column
    '.euiTableHeaderCell': {
      minWidth: '100px'
    },
    // Make sure the pagination follows the scroll
    '> div:last-child': {
      position: 'sticky',
      left: 0
    },
    // Show filter buttons on row hover or focus
    'tr:hover .insDataTableFormat__filter, .insDataTableFormat__filter:focus': {
      opacity: 1
    },
    '.insDataTableFormat__filter': {
      opacity: 0
    }
  })
};