"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformSearchSourceOut = transformSearchSourceOut;
var _common = require("@kbn/data-plugin/common");
var _common2 = require("../../../../common");
var _kibana_services = require("../../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function transformSearchSourceOut(kibanaSavedObjectMeta = {}, references = []) {
  const {
    searchSourceJSON
  } = kibanaSavedObjectMeta;
  if (!searchSourceJSON) {
    return {};
  }
  let parsedSearchSource;
  try {
    parsedSearchSource = (0, _common.parseSearchSourceJSON)(searchSourceJSON);
  } catch (parseError) {
    _kibana_services.logger.warn(`Unable to parse searchSourceJSON. Error: ${parseError.message}`);
    return {};
  }
  let searchSource;
  try {
    searchSource = (0, _common.injectReferences)(parsedSearchSource, references);
  } catch (injectError) {
    _kibana_services.logger.warn(`Unable to transform filter and query state on read. Error: ${injectError.message}`);
    // fallback to parsed if injection fails
    searchSource = parsedSearchSource;
  }
  try {
    const filters = (0, _common2.cleanFiltersForSerialize)(searchSource.filter);
    const query = searchSource.query ? (0, _common2.migrateLegacyQuery)(searchSource.query) : undefined;
    return {
      filters,
      query
    };
  } catch (error) {
    _kibana_services.logger.warn(`Unexpected error transforming filter and query state on read. Error: ${error.message}`);
    return {};
  }
}