"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerReadRoute = registerReadRoute;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../constants");
var _schemas = require("./schemas");
var _read = require("./read");
var _dashboard_state_schemas = require("../dashboard_state_schemas");
var _scope_tooling = require("../scope_tooling");
var _constants2 = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function registerReadRoute(router) {
  const readRoute = router.get({
    path: `${_constants2.DASHBOARD_API_PATH}/{id}`,
    summary: `Get a dashboard`,
    ..._constants.commonRouteConfig
  });
  readRoute.addVersion({
    version: _constants.INTERNAL_API_VERSION,
    validate: () => ({
      request: {
        params: _configSchema.schema.object({
          id: _configSchema.schema.string({
            meta: {
              description: 'A unique identifier for the dashboard.'
            }
          })
        }),
        query: _configSchema.schema.maybe(_configSchema.schema.object({
          allowUnmappedKeys: _configSchema.schema.maybe(_dashboard_state_schemas.allowUnmappedKeysSchema)
        }))
      },
      response: {
        200: {
          body: _schemas.getReadResponseBodySchema
        }
      }
    })
  }, async (ctx, req, res) => {
    try {
      var _req$query$allowUnmap, _req$query;
      const result = await (0, _read.read)(ctx, req.params.id);
      const allowUnmappedKeys = (_req$query$allowUnmap = (_req$query = req.query) === null || _req$query === void 0 ? void 0 : _req$query.allowUnmappedKeys) !== null && _req$query$allowUnmap !== void 0 ? _req$query$allowUnmap : false;
      const {
        data,
        warnings
      } = !allowUnmappedKeys ? (0, _scope_tooling.stripUnmappedKeys)(result.data) : {
        data: result.data,
        warnings: []
      };
      return res.ok({
        body: {
          ...result,
          data,
          ...((warnings === null || warnings === void 0 ? void 0 : warnings.length) && {
            warnings
          })
        }
      });
    } catch (e) {
      if (e.isBoom && e.output.statusCode === 404) {
        return res.notFound({
          body: {
            message: `A dashboard with ID ${req.params.id}] was not found.`
          }
        });
      }
      if (e.isBoom && e.output.statusCode === 403) {
        return res.forbidden();
      }
      return res.badRequest(e.message);
    }
  });
}