"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.create = create;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _constants = require("../../../common/constants");
var _transforms = require("../transforms");
var _saved_object_utils = require("../saved_object_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function create(requestCtx, createBody) {
  var _accessControl$access;
  const {
    core
  } = await requestCtx.resolve(['core']);
  const {
    access_control: accessControl,
    ...restOfData
  } = createBody.data;
  const {
    attributes: soAttributes,
    references: soReferences,
    error: transformInError
  } = (0, _transforms.transformDashboardIn)(restOfData);
  if (transformInError) {
    throw _boom.default.badRequest(`Invalid data. ${transformInError.message}`);
  }
  const supportsAccessControl = core.savedObjects.typeRegistry.supportsAccessControl(_constants.DASHBOARD_SAVED_OBJECT_TYPE);
  const savedObject = await core.savedObjects.client.create(_constants.DASHBOARD_SAVED_OBJECT_TYPE, soAttributes, {
    references: soReferences,
    ...(createBody.id && {
      id: createBody.id
    }),
    ...(createBody.spaces && {
      initialNamespaces: createBody.spaces
    }),
    ...((accessControl === null || accessControl === void 0 ? void 0 : accessControl.access_mode) && supportsAccessControl && {
      accessControl: {
        accessMode: (_accessControl$access = accessControl.access_mode) !== null && _accessControl$access !== void 0 ? _accessControl$access : 'default'
      }
    })
  });
  return (0, _saved_object_utils.getDashboardCRUResponseBody)(savedObject, 'create');
}