"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDashboardListingTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _contentManagementContentInsightsPublic = require("@kbn/content-management-content-insights-public");
var _ebtTools = require("@kbn/ebt-tools");
var _std = require("@kbn/std");
var _constants = require("../../../common/constants");
var _dashboard_app_strings = require("../../dashboard_app/_dashboard_app_strings");
var _dashboard_client = require("../../dashboard_client");
var _access_control_service = require("../../services/access_control_service");
var _dashboard_backup_service = require("../../services/dashboard_backup_service");
var _dashboard_recently_accessed_service = require("../../services/dashboard_recently_accessed_service");
var _kibana_services = require("../../services/kibana_services");
var _logger = require("../../services/logger");
var _get_dashboard_capabilities = require("../../utils/get_dashboard_capabilities");
var _telemetry_constants = require("../../utils/telemetry_constants");
var _dashboard_listing_strings = require("../_dashboard_listing_strings");
var _confirm_overlays = require("../confirm_overlays");
var _dashboard_listing_empty_prompt = require("../dashboard_listing_empty_prompt");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/dashboard/public/dashboard_listing/hooks/use_dashboard_listing_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const useDashboardListingTable = ({
  dashboardListingId = 'dashboard',
  disableCreateDashboardButton,
  getDashboardUrl,
  goToDashboard,
  headingId = 'dashboardListingHeading',
  initialFilter,
  urlStateEnabled,
  useSessionStorageIntegration,
  showCreateDashboardButton = true
}) => {
  const {
    getEntityName,
    getTableListTitle,
    getEntityNamePlural
  } = _dashboard_listing_strings.dashboardListingTableStrings;
  const title = getTableListTitle();
  const entityName = getEntityName();
  const entityNamePlural = getEntityNamePlural();
  const [pageDataTestSubject, setPageDataTestSubject] = (0, _react.useState)();
  const [hasInitialFetchReturned, setHasInitialFetchReturned] = (0, _react.useState)(false);
  const dashboardBackupService = (0, _react.useMemo)(() => (0, _dashboard_backup_service.getDashboardBackupService)(), []);
  const [unsavedDashboardIds, setUnsavedDashboardIds] = (0, _react.useState)(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  const accessControlClient = (0, _access_control_service.getAccessControlClient)();
  const listingLimit = _kibana_services.coreServices.uiSettings.get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = _kibana_services.coreServices.uiSettings.get(SAVED_OBJECTS_PER_PAGE_SETTING);
  const createItem = (0, _react.useCallback)(() => {
    if (useSessionStorageIntegration && dashboardBackupService.dashboardHasUnsavedEdits()) {
      (0, _confirm_overlays.confirmCreateWithUnsaved)(() => {
        dashboardBackupService.clearState();
        goToDashboard();
      }, goToDashboard);
      return;
    }
    goToDashboard();
  }, [dashboardBackupService, goToDashboard, useSessionStorageIntegration]);
  const updateItemMeta = (0, _react.useCallback)(async ({
    id,
    ...updatedState
  }) => {
    const dashboard = await _dashboard_client.findService.findById(id);
    if (dashboard.status === 'error') {
      return;
    }
    const {
      references,
      ...currentState
    } = dashboard.attributes;
    await _dashboard_client.dashboardClient.update(id, {
      ...currentState,
      ...updatedState
    }, dashboard.references);
    setUnsavedDashboardIds(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackupService]);
  const contentEditorValidators = (0, _react.useMemo)(() => ({
    title: [{
      type: 'warning',
      fn: async (value, id) => {
        if (id) {
          try {
            const dashboard = await _dashboard_client.findService.findById(id);
            if (dashboard.status === 'error') {
              return;
            }
            const validTitle = await (0, _dashboard_client.checkForDuplicateDashboardTitle)({
              title: value,
              copyOnSave: false,
              lastSavedTitle: dashboard.attributes.title,
              isTitleDuplicateConfirmed: false
            });
            if (!validTitle) {
              throw new Error(_dashboard_listing_strings.dashboardListingErrorStrings.getDuplicateTitleWarning(value));
            }
          } catch (e) {
            return e.message;
          }
        }
      }
    }]
  }), []);
  const emptyPrompt = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_dashboard_listing_empty_prompt.DashboardListingEmptyPrompt, {
    createItem: createItem,
    disableCreateDashboardButton: disableCreateDashboardButton,
    goToDashboard: goToDashboard,
    setUnsavedDashboardIds: setUnsavedDashboardIds,
    unsavedDashboardIds: unsavedDashboardIds,
    useSessionStorageIntegration: useSessionStorageIntegration,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }), [createItem, disableCreateDashboardButton, goToDashboard, unsavedDashboardIds, useSessionStorageIntegration]);
  const findItems = (0, _react.useCallback)(async (searchTerm, {
    references,
    referencesToExclude
  } = {}) => {
    const searchStartTime = window.performance.now();
    const [userResponse, globalPrivilegeResponse] = await Promise.allSettled([_kibana_services.coreServices.userProfile.getCurrent(), accessControlClient.checkGlobalPrivilege(_constants.DASHBOARD_SAVED_OBJECT_TYPE)]);
    const userId = userResponse.status === 'fulfilled' ? userResponse.value.uid : undefined;
    const isGloballyAuthorized = globalPrivilegeResponse.status === 'fulfilled' ? globalPrivilegeResponse.value.isGloballyAuthorized : false;
    return _dashboard_client.findService.search({
      search: searchTerm,
      per_page: listingLimit,
      tags: {
        included: (references !== null && references !== void 0 ? references : []).map(({
          id
        }) => id),
        excluded: (referencesToExclude !== null && referencesToExclude !== void 0 ? referencesToExclude : []).map(({
          id
        }) => id)
      }
    }).then(({
      total,
      dashboards
    }) => {
      const searchEndTime = window.performance.now();
      const searchDuration = searchEndTime - searchStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_kibana_services.coreServices.analytics, {
        eventName: _telemetry_constants.SAVED_OBJECT_LOADED_TIME,
        duration: searchDuration,
        meta: {
          saved_object_type: _constants.DASHBOARD_SAVED_OBJECT_TYPE
        }
      });
      const tagApi = _kibana_services.savedObjectsTaggingService === null || _kibana_services.savedObjectsTaggingService === void 0 ? void 0 : _kibana_services.savedObjectsTaggingService.getTaggingApi();
      return {
        total,
        hits: dashboards.map(({
          id,
          data,
          meta
        }) => {
          var _data$access_control, _data$access_control2, _data$access_control3;
          const canManageAccessControl = isGloballyAuthorized || accessControlClient.checkUserAccessControl({
            accessControl: {
              owner: data === null || data === void 0 ? void 0 : (_data$access_control = data.access_control) === null || _data$access_control === void 0 ? void 0 : _data$access_control.owner,
              accessMode: data === null || data === void 0 ? void 0 : (_data$access_control2 = data.access_control) === null || _data$access_control2 === void 0 ? void 0 : _data$access_control2.access_mode
            },
            createdBy: meta.created_at,
            userId
          });
          return {
            type: 'dashboard',
            id,
            updatedAt: meta.updated_at,
            createdAt: meta.created_at,
            createdBy: meta.created_by,
            updatedBy: meta.updated_by,
            references: tagApi && data.tags ? data.tags.map(tagApi.ui.tagIdToReference) : [],
            managed: meta.managed,
            attributes: {
              title: data.title,
              description: data.description,
              timeRestore: Boolean(data.time_range)
            },
            canManageAccessControl,
            accessMode: data === null || data === void 0 ? void 0 : (_data$access_control3 = data.access_control) === null || _data$access_control3 === void 0 ? void 0 : _data$access_control3.access_mode
          };
        })
      };
    });
  }, [listingLimit, accessControlClient]);
  const deleteItems = (0, _react.useCallback)(async dashboardsToDelete => {
    try {
      const deleteStartTime = window.performance.now();
      await (0, _std.asyncMap)(dashboardsToDelete, async ({
        id
      }) => {
        await _dashboard_client.dashboardClient.delete(id);
        dashboardBackupService.clearState(id);
      });
      const deleteDuration = window.performance.now() - deleteStartTime;
      (0, _ebtTools.reportPerformanceMetricEvent)(_kibana_services.coreServices.analytics, {
        eventName: _telemetry_constants.SAVED_OBJECT_DELETE_TIME,
        duration: deleteDuration,
        meta: {
          saved_object_type: _constants.DASHBOARD_SAVED_OBJECT_TYPE,
          total: dashboardsToDelete.length
        }
      });
    } catch (error) {
      _kibana_services.coreServices.notifications.toasts.addError(error, {
        title: _dashboard_listing_strings.dashboardListingErrorStrings.getErrorDeletingDashboardToast()
      });
    }
    setUnsavedDashboardIds(dashboardBackupService.getDashboardIdsWithUnsavedChanges());
  }, [dashboardBackupService]);
  const editItem = (0, _react.useCallback)(({
    id
  }) => goToDashboard(id, 'edit'), [goToDashboard]);
  const onFetchSuccess = (0, _react.useCallback)(() => {
    if (!hasInitialFetchReturned) {
      setHasInitialFetchReturned(true);
    }
  }, [hasInitialFetchReturned]);
  const getDetailViewLink = (0, _react.useCallback)(({
    id,
    attributes: {
      timeRestore
    }
  }) => getDashboardUrl(id, timeRestore), [getDashboardUrl]);
  const tableListViewTableProps = (0, _react.useMemo)(() => {
    const {
      showWriteControls
    } = (0, _get_dashboard_capabilities.getDashboardCapabilities)();
    return {
      contentEditor: {
        onSave: updateItemMeta,
        customValidators: contentEditorValidators
      },
      createItem: !showWriteControls || !showCreateDashboardButton ? undefined : createItem,
      deleteItems: !showWriteControls ? undefined : deleteItems,
      editItem: !showWriteControls ? undefined : editItem,
      emptyPrompt,
      entityName,
      entityNamePlural,
      findItems,
      getDetailViewLink,
      headingId,
      id: dashboardListingId,
      initialFilter,
      initialPageSize,
      listingLimit,
      onFetchSuccess,
      setPageDataTestSubject,
      title,
      urlStateEnabled,
      createdByEnabled: true,
      recentlyAccessed: (0, _dashboard_recently_accessed_service.getDashboardRecentlyAccessedService)(),
      rowItemActions: item => {
        const isDisabled = () => {
          if (!showWriteControls) return true;
          if ((item === null || item === void 0 ? void 0 : item.managed) === true) return true;
          if ((item === null || item === void 0 ? void 0 : item.canManageAccessControl) === false && (item === null || item === void 0 ? void 0 : item.accessMode) === 'write_restricted') return true;
          return false;
        };
        const getReason = () => {
          if (!showWriteControls) {
            return _dashboard_app_strings.contentEditorFlyoutStrings.readonlyReason.missingPrivileges;
          }
          if (item !== null && item !== void 0 && item.managed) {
            return _dashboard_app_strings.contentEditorFlyoutStrings.readonlyReason.managedEntity;
          }
          if ((item === null || item === void 0 ? void 0 : item.canManageAccessControl) === false) {
            return _dashboard_app_strings.contentEditorFlyoutStrings.readonlyReason.accessControl;
          }
        };
        return {
          edit: {
            enabled: !isDisabled(),
            reason: getReason()
          },
          delete: {
            enabled: !isDisabled(),
            reason: getReason()
          }
        };
      }
    };
  }, [contentEditorValidators, createItem, dashboardListingId, deleteItems, editItem, emptyPrompt, entityName, entityNamePlural, findItems, getDetailViewLink, headingId, initialFilter, initialPageSize, listingLimit, onFetchSuccess, showCreateDashboardButton, title, updateItemMeta, urlStateEnabled]);
  const refreshUnsavedDashboards = (0, _react.useCallback)(() => setUnsavedDashboardIds((0, _dashboard_backup_service.getDashboardBackupService)().getDashboardIdsWithUnsavedChanges()), []);
  const contentInsightsClient = (0, _react.useMemo)(() => new _contentManagementContentInsightsPublic.ContentInsightsClient({
    http: _kibana_services.coreServices.http,
    logger: _logger.logger
  }, {
    domainId: 'dashboard'
  }), []);
  return {
    hasInitialFetchReturned,
    pageDataTestSubject,
    refreshUnsavedDashboards,
    tableListViewTableProps,
    unsavedDashboardIds,
    contentInsightsClient
  };
};
exports.useDashboardListingTable = useDashboardListingTable;