"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deserializeLayout = deserializeLayout;
var _uuid = require("uuid");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function deserializeLayout(panels, getReferences) {
  const layout = {
    panels: {},
    sections: {}
  };
  const childState = {};
  function pushPanel(panel, sectionId) {
    var _panel$uid;
    const panelId = (_panel$uid = panel.uid) !== null && _panel$uid !== void 0 ? _panel$uid : (0, _uuid.v4)();
    layout.panels[panelId] = {
      type: panel.type,
      grid: {
        ...panel.grid,
        ...(sectionId && {
          sectionId
        })
      }
    };
    childState[panelId] = {
      rawState: {
        ...panel.config
      },
      references: getReferences(panelId)
    };
  }
  panels === null || panels === void 0 ? void 0 : panels.forEach(widget => {
    if ((0, _common.isDashboardSection)(widget)) {
      const {
        panels: sectionPanels,
        uid,
        ...restOfSection
      } = widget;
      const sectionId = uid !== null && uid !== void 0 ? uid : (0, _uuid.v4)();
      layout.sections[sectionId] = {
        collapsed: false,
        ...restOfSection
      };
      sectionPanels.forEach(panel => {
        pushPanel(panel, sectionId);
      });
    } else {
      // if not a section, then this widget is a panel
      pushPanel(widget);
    }
  });
  return {
    layout,
    childState
  };
}