"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isApiCompatible = exports.UnlinkFromLibraryAction = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _kibana_services = require("../services/kibana_services");
var _dashboard_actions_strings = require("./_dashboard_actions_strings");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const isApiCompatible = api => {
  var _api$parentApi;
  return Boolean((0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _presentationPublishing.apiHasLibraryTransforms)(api) && (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiHasType)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && typeof ((_api$parentApi = api.parentApi) === null || _api$parentApi === void 0 ? void 0 : _api$parentApi.replacePanel) === 'function');
};
exports.isApiCompatible = isApiCompatible;
class UnlinkFromLibraryAction {
  constructor() {
    (0, _defineProperty2.default)(this, "type", _constants.ACTION_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "id", _constants.ACTION_UNLINK_FROM_LIBRARY);
    (0, _defineProperty2.default)(this, "order", 15);
    (0, _defineProperty2.default)(this, "grouping", [_constants.DASHBOARD_ACTION_GROUP]);
  }
  getDisplayName({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getDisplayName();
  }
  getIconType({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    return 'folderExclamation';
  }
  async isCompatible({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) {
      // either a an `unlinkFromLibrary` method or a `getByValueState` method is required
      return false;
    }
    return (0, _presentationPublishing.getInheritedViewMode)(embeddable) === 'edit' && (await embeddable.canUnlinkFromLibrary());
  }
  async execute({
    embeddable
  }) {
    if (!isApiCompatible(embeddable)) throw new _public.IncompatibleActionError();
    const title = (0, _presentationPublishing.getTitle)(embeddable);
    try {
      const {
        references,
        rawState
      } = embeddable.getSerializedStateByValue();
      await embeddable.parentApi.replacePanel(embeddable.uuid, {
        panelType: embeddable.type,
        serializedState: {
          rawState: {
            ...rawState,
            title
          },
          references
        }
      });
      _kibana_services.coreServices.notifications.toasts.addSuccess({
        title: _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getSuccessMessage(title ? `'${title}'` : ''),
        'data-test-subj': 'unlinkPanelSuccess'
      });
    } catch (e) {
      _kibana_services.coreServices.notifications.toasts.addDanger({
        title: _dashboard_actions_strings.dashboardUnlinkFromLibraryActionStrings.getFailureMessage(title ? `'${title}'` : ''),
        'data-test-subj': 'unlinkPanelFailure'
      });
    }
  }
}
exports.UnlinkFromLibraryAction = UnlinkFromLibraryAction;