"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConvertLegacyMarkdownAction = void 0;
var _i18n = require("@kbn/i18n");
var _presentationContainers = require("@kbn/presentation-containers");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public = require("@kbn/ui-actions-plugin/public");
var _public2 = require("@kbn/visualizations-plugin/public");
var _constants = require("./constants");
var _constants2 = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const displayName = _i18n.i18n.translate('dashboardMarkdown.convertLegacyDisplayName', {
  defaultMessage: 'Convert to new markdown'
});
const compatibilityCheck = api => (0, _presentationPublishing.apiHasUniqueId)(api) && (0, _presentationPublishing.apiCanAccessViewMode)(api) && (0, _public2.apiHasVisualizeConfig)(api) && (0, _presentationPublishing.apiHasParentApi)(api) && (0, _presentationContainers.apiIsPresentationContainer)(api.parentApi);
const getConvertLegacyMarkdownAction = () => ({
  id: _constants.CONVERT_LEGACY_MARKDOWN_ACTION_ID,
  getIconType: () => 'merge',
  showNotification: true,
  isCompatible: async ({
    embeddable
  }) => {
    if (!compatibilityCheck(embeddable) || (0, _presentationPublishing.getInheritedViewMode)(embeddable) !== 'edit') {
      return false;
    }
    const vis = embeddable.getVis();
    return vis.type.name === 'markdown';
  },
  order: 49,
  execute: async ({
    embeddable
  }) => {
    if (!compatibilityCheck(embeddable)) throw new _public.IncompatibleActionError();
    const legacyContent = embeddable.getVis().params.markdown;
    await embeddable.parentApi.replacePanel(embeddable.uuid, {
      panelType: _constants2.MARKDOWN_EMBEDDABLE_TYPE,
      serializedState: {
        rawState: {
          content: legacyContent
        }
      }
    });
  },
  getDisplayName: () => displayName
});
exports.getConvertLegacyMarkdownAction = getConvertLegacyMarkdownAction;