"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dashboardTools = exports.DASHBOARD_NAMESPACE = exports.DASHBOARD_AGENT_FEATURE_FLAG_DEFAULT = exports.DASHBOARD_AGENT_FEATURE_FLAG = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Feature flag for enabling the dashboard agent
 */
const DASHBOARD_AGENT_FEATURE_FLAG = exports.DASHBOARD_AGENT_FEATURE_FLAG = 'dashboardAgent.enabled';
const DASHBOARD_AGENT_FEATURE_FLAG_DEFAULT = exports.DASHBOARD_AGENT_FEATURE_FLAG_DEFAULT = false;

/**
 * Namespace for dashboard-related tools and agents
 */
const DASHBOARD_NAMESPACE = exports.DASHBOARD_NAMESPACE = 'platform.dashboard';

/**
 * Helper function to create tool IDs in the dashboard namespace
 */
const dashboardTool = toolName => {
  return `${DASHBOARD_NAMESPACE}.${toolName}`;
};

/**
 * Ids of built-in dashboard tools.
 * These tools are registered by the dashboard_agent plugin.
 */
const dashboardTools = exports.dashboardTools = {
  createDashboard: dashboardTool('create_dashboard'),
  updateDashboard: dashboardTool('update_dashboard')
};