"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomBrandingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _i18n = require("@kbn/i18n");
var _server2 = require("@kbn/license-api-guard-plugin/server");
var _constants = require("../common/constants");
var _ui_settings = require("./ui_settings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const settingsKeys = ['logo', 'customizedLogo', 'faviconPNG', 'faviconSVG', 'pageTitle'];
class CustomBrandingPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "license", void 0);
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "licensingSubscription", void 0);
    (0, _defineProperty2.default)(this, "isValidLicense", false);
    (0, _defineProperty2.default)(this, "getBrandingFrom", async uiSettingsClient => {
      const branding = {};
      for (let i = 0; i < settingsKeys.length; i++) {
        const key = settingsKeys[i];
        const fullKey = `xpackCustomBranding:${key}`;
        const value = await uiSettingsClient.get(fullKey);
        if (value) {
          branding[key] = value;
        }
      }
      return branding;
    });
    this.logger = initializerContext.logger.get();
    this.license = new _server2.License();
  }
  setup(core) {
    this.logger.debug('customBranding: Setup');
    this.license.setup({
      pluginName: _constants.PLUGIN.getI18nName(_i18n.i18n),
      logger: this.logger
    });
    (0, _ui_settings.registerUiSettings)(core);
    const fetchFn = async (request, unauthenticated) => {
      if (!this.isValidLicense) {
        return {};
      }
      const [coreStart] = await core.getStartServices();
      const soClient = unauthenticated ? coreStart.savedObjects.getScopedClient(request, {
        excludedExtensions: [_server.SECURITY_EXTENSION_ID]
      }) : coreStart.savedObjects.getScopedClient(request);
      const uiSettings = coreStart.uiSettings.globalAsScopedToClient(soClient);
      return await this.getBrandingFrom(uiSettings);
    };
    core.customBranding.register(fetchFn);
    return {};
  }
  start(_core, {
    licensing
  }) {
    this.logger.debug('customBranding: Started');
    this.license.start({
      pluginId: _constants.PLUGIN.ID,
      minimumLicenseType: _constants.PLUGIN.MINIMUM_LICENSE_REQUIRED,
      licensing
    });
    this.licensingSubscription = licensing.license$.subscribe(next => {
      this.isValidLicense = next.hasAtLeast('enterprise');
    });
    return {};
  }
  stop() {
    var _this$licensingSubscr;
    (_this$licensingSubscr = this.licensingSubscription) === null || _this$licensingSubscr === void 0 ? void 0 : _this$licensingSubscr.unsubscribe();
  }
}
exports.CustomBrandingPlugin = CustomBrandingPlugin;