"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AutoFollowPatternList = void 0;
var _reactRedux = require("react-redux");
var _constants = require("../../../constants");
var _selectors = require("../../../store/selectors");
var _actions = require("../../../store/actions");
var _auto_follow_pattern_list = require("./auto_follow_pattern_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scope = _constants.SECTIONS.AUTO_FOLLOW_PATTERN;
const mapStateToProps = state => ({
  autoFollowPatterns: (0, _selectors.getListAutoFollowPatterns)(state),
  autoFollowPatternId: (0, _selectors.getSelectedAutoFollowPatternId)('detail')(state),
  apiStatus: (0, _selectors.getApiStatus)(scope)(state),
  apiError: (0, _selectors.getApiError)(scope)(state),
  isAuthorized: (0, _selectors.isApiAuthorized)(scope)(state)
});
const mapDispatchToProps = dispatch => ({
  loadAutoFollowPatterns: inBackground => dispatch((0, _actions.loadAutoFollowPatterns)(inBackground)),
  selectAutoFollowPattern: id => dispatch((0, _actions.selectDetailAutoFollowPattern)(id)),
  loadAutoFollowStats: () => dispatch((0, _actions.loadAutoFollowStats)())
});
const AutoFollowPatternList = exports.AutoFollowPatternList = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_auto_follow_pattern_list.AutoFollowPatternList);