"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FollowerIndexResumeProvider = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _reactRedux = require("react-redux");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _public = require("@kbn/kibana-react-plugin/public");
var _routing = require("../../services/routing");
var _actions = require("../../store/actions");
var _utils = require("../../../../common/services/utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/cross_cluster_replication/public/app/components/follower_index_actions_providers/follower_index_resume_provider.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class FollowerIndexResumeProviderUi extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalOpen: false,
      ids: null
    });
    (0, _defineProperty2.default)(this, "onMouseOverModal", event => {
      // This component can sometimes be used inside of an EuiToolTip, in which case mousing over
      // the modal can trigger the tooltip. Stopping propagation prevents this.
      event.stopPropagation();
    });
    (0, _defineProperty2.default)(this, "resumeFollowerIndex", id => {
      this.setState({
        isModalOpen: true,
        ids: (0, _utils.arrify)(id)
      });
    });
    (0, _defineProperty2.default)(this, "onConfirm", () => {
      this.props.resumeFollowerIndex(this.state.ids);
      this.setState({
        isModalOpen: false,
        ids: null
      });
      this.props.onConfirm && this.props.onConfirm();
    });
    (0, _defineProperty2.default)(this, "closeConfirmModal", () => {
      this.setState({
        isModalOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "renderModal", () => {
      const {
        ids
      } = this.state;
      const isSingle = ids.length === 1;
      const title = isSingle ? _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.resumeSingleTitle', {
        defaultMessage: `Resume replication to follower index ''{name}''?`,
        values: {
          name: ids[0]
        }
      }) : _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.resumeMultipleTitle', {
        defaultMessage: `Resume replication to {count} follower indices?`,
        values: {
          count: ids.length
        }
      });
      const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/mouse-events-have-key-events
        _react.default.createElement(_eui.EuiConfirmModal, {
          "aria-labelledby": confirmModalTitleId,
          title: title,
          titleProps: {
            id: confirmModalTitleId
          },
          onCancel: this.closeConfirmModal,
          onConfirm: this.onConfirm,
          cancelButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.cancelButtonText', {
            defaultMessage: 'Cancel'
          }),
          buttonColor: "primary",
          confirmButtonText: _i18n.i18n.translate('xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.confirmButtonText', {
            defaultMessage: 'Resume replication'
          }),
          onMouseOver: this.onMouseOverModal,
          "data-test-subj": "resumeReplicationConfirmation",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 74,
            columnNumber: 7
          }
        }, isSingle ? /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 97,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.singleResumeDescription",
          defaultMessage: "Replication resumes using the default advanced settings. To use custom advanced settings, {editLink}.",
          values: {
            editLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _public.reactRouterNavigate)(_routing.routing._reactRouter.history, _routing.routing.getFollowerIndexPath(ids[0])), {
              "data-test-subj": "editLink",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 104,
                columnNumber: 19
              }
            }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.singleResumeEditLink",
              defaultMessage: "edit the follower index",
              __self: this,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 111,
                columnNumber: 21
              }
            }))
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 98,
            columnNumber: 13
          }
        })) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 121,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 122,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.multipleResumeDescriptionWithSettingWarning",
          defaultMessage: "Replication resumes using the default advanced settings.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 123,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 129,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.crossClusterReplication.resumeFollowerIndex.confirmModal.multipleResumeDescription",
          defaultMessage: "Replication will resume on these follower indices:",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 130,
            columnNumber: 15
          }
        })), /*#__PURE__*/_react.default.createElement("ul", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 13
          }
        }, ids.map(id => /*#__PURE__*/_react.default.createElement("li", {
          key: id,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 17
          }
        }, id)))))
      );
    });
  }
  render() {
    const {
      children
    } = this.props;
    const {
      isModalOpen
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 152,
        columnNumber: 7
      }
    }, children(this.resumeFollowerIndex), isModalOpen && this.renderModal());
  }
}
(0, _defineProperty2.default)(FollowerIndexResumeProviderUi, "propTypes", {
  onConfirm: _propTypes.default.func
});
const mapDispatchToProps = dispatch => ({
  resumeFollowerIndex: id => dispatch((0, _actions.resumeFollowerIndex)(id))
});
const FollowerIndexResumeProvider = exports.FollowerIndexResumeProvider = (0, _reactRedux.connect)(undefined, mapDispatchToProps)(FollowerIndexResumeProviderUi);