"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScroll = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook for handling scroll styles.
 *
 * @param withMask - whether to apply a mask to the scrollable content.
 * @returns the scroll styles.
 */
const useScroll = (withMask = false) => {
  const scrollStyles = (0, _react.css)`
    ${(0, _eui.useEuiOverflowScroll)('y', withMask)}
    --secondary-menu-header-height: 44px;
    scroll-padding-top: var(--secondary-menu-header-height);
  `;
  return scrollStyles;
};
exports.useScroll = useScroll;