"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_high_contrast_mode_styles = require("../../hooks/use_high_contrast_mode_styles");
var _constants = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/navigation/src/components/menu_item/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MenuItem = exports.MenuItem = /*#__PURE__*/(0, _react.forwardRef)(({
  children,
  iconType,
  id,
  isCurrent = false,
  isHighlighted,
  isLabelVisible = true,
  isTruncated = true,
  ...props
}, ref) => {
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const isSingleWord = typeof children === 'string' && !children.includes(' ');
  const iconWrapperClassName = `${_constants.NAVIGATION_SELECTOR_PREFIX}-iconWrapper`;
  const buttonStyles = (0, _react2.css)`
      --menu-item-text-color: ${isHighlighted ? euiTheme.components.buttons.textColorPrimary : euiTheme.components.buttons.textColorText};
      --high-contrast-hover-indicator-color: var(--menu-item-text-color);
      ${(0, _use_high_contrast_mode_styles.useHighContrastModeStyles)(`.${iconWrapperClassName}`)};

      width: 100%;
      position: relative;
      overflow: hidden;
      align-items: center;
      justify-content: center;
      display: flex;
      flex-direction: column;
      /* 3px is from Figma; there is no token */
      gap: 3px;
      /* eslint-disable-next-line @elastic/eui/no-css-color */
      color: var(--menu-item-text-color);
      /* Focus affordance with border on the iconWrapper instead */
      outline: none !important;

      .${iconWrapperClassName} {
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
        height: ${euiTheme.size.xl};
        width: ${euiTheme.size.xl};
        border-radius: ${euiTheme.border.radius.medium};
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimary : euiTheme.components.buttons.backgroundText};
        z-index: 1;
      }

      .${iconWrapperClassName}::before {
        content: '';
        position: absolute;
        inset: 0;
        border-radius: ${euiTheme.border.radius.medium};
        background-color: transparent;
        z-index: 0;
      }

      &:focus-visible .${iconWrapperClassName} {
        border: ${euiTheme.border.width.thick} solid
          ${isHighlighted ? euiTheme.colors.textPrimary : euiTheme.colors.textParagraph};
      }

      &:hover .${iconWrapperClassName}::before {
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimaryHover : euiTheme.components.buttons.backgroundTextHover};
      }

      &:active .${iconWrapperClassName}::before {
        background-color: ${isHighlighted ? euiTheme.components.buttons.backgroundPrimaryActive : euiTheme.components.buttons.backgroundTextActive};
      }
    `;
  const truncatedStyles = isTruncated && (isSingleWord ? (0, _react2.css)`
            /* Single word: stay on one line, truncate with ellipsis */
            white-space: nowrap;
            text-overflow: ellipsis;
          ` : (0, _react2.css)`
            /* Multiple words: allow wrapping to 2 lines */
            display: -webkit-box;
            -webkit-box-orient: vertical;
            line-clamp: 2;
            -webkit-line-clamp: 2;
          `);
  const textStyles = (0, _react2.css)`
      ${(0, _eui.euiFontSize)(euiThemeContext, 'xxs', {
    unit: 'px'
  }).fontSize};
      font-weight: ${euiTheme.font.weight.semiBold};
    `;
  const labelStyles = (0, _react2.css)`
      ${truncatedStyles}
      ${textStyles}
      overflow: hidden;
      max-width: 100%;
      padding: 0 ${euiTheme.size.s};
    `;
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: iconWrapperClassName,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_react.Suspense, {
    fallback: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "aria-hidden": true,
      color: "currentColor",
      type: "empty",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 31
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "aria-hidden": true,
    color: "currentColor",
    type: iconType || 'empty',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }))), isLabelVisible ? /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    textAlign: "center",
    css: labelStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 11
    }
  }, children) : /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }, children)));
  const commonProps = {
    css: buttonStyles,
    'data-menu-item': true,
    'data-highlighted': isHighlighted ? 'true' : 'false'
  };
  if (props.href === undefined) {
    const buttonProps = props;
    return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
      id: id,
      ref: ref
    }, commonProps, buttonProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 9
      }
    }), content);
  } else {
    const anchorProps = props;
    return /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({
      "aria-current": isCurrent ? 'page' : undefined,
      id: id,
      ref: ref
    }, commonProps, anchorProps, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 204,
        columnNumber: 9
      }
    }), content);
  }
});