"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createEuiButtonItem = createEuiButtonItem;
exports.createEuiListItem = createEuiListItem;
exports.createOverviewLink = createOverviewLink;
exports.createRecentNavLink = createRecentNavLink;
exports.isModifiedOrPrevented = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _to_nav_link = require("../../nav_links/to_nav_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/nav_link.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const isModifiedOrPrevented = event => event.metaKey || event.altKey || event.ctrlKey || event.shiftKey || event.defaultPrevented;
exports.isModifiedOrPrevented = isModifiedOrPrevented;
// TODO #64541
// Set return type to EuiListGroupItemProps
// Currently it's a subset of EuiListGroupItemProps+FlyoutMenuItem for CollapsibleNav and NavDrawer
// But FlyoutMenuItem isn't exported from EUI
function createEuiListItem({
  link,
  appId,
  basePath,
  onClick = () => {},
  navigateToUrl,
  dataTestSubj,
  externalLink = false,
  iconProps
}) {
  const {
    href,
    id,
    title,
    euiIconType,
    icon,
    tooltip,
    url
  } = link;
  return {
    label: tooltip !== null && tooltip !== void 0 ? tooltip : title,
    href,
    /* Use href and onClick to support "open in new tab" and SPA navigation in the same link */
    onClick(event) {
      if (!isModifiedOrPrevented(event)) {
        onClick();
      }
      if (!externalLink &&
      // ignore external links
      event.button === 0 &&
      // ignore everything but left clicks
      !isModifiedOrPrevented(event)) {
        event.preventDefault();
        navigateToUrl(url);
      }
    },
    isActive: !externalLink && appId === id,
    'data-test-subj': dataTestSubj,
    ...(basePath && {
      iconType: euiIconType,
      iconProps,
      icon: !euiIconType && icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: basePath.prepend(`/${icon}`),
        size: "m",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 32
        }
      }) : undefined
    })
  };
}
function createEuiButtonItem({
  link,
  onClick = () => {},
  navigateToUrl,
  dataTestSubj
}) {
  const {
    href,
    url,
    id
  } = link;
  return {
    href,
    /* Use href and onClick to support "open in new tab" and SPA navigation in the same link */
    onClick(event) {
      if (!isModifiedOrPrevented(event)) {
        onClick();
      }
      event.preventDefault();
      navigateToUrl(url);
    },
    'data-test-subj': dataTestSubj || `collapsibleNavAppButton-${id}`
  };
}
function createOverviewLink({
  link,
  onClick = () => {},
  navigateToUrl
}) {
  const {
    href,
    url
  } = link;
  return {
    href,
    /* Use href and onClick to support "open in new tab" and SPA navigation in the same link */
    onClick(event) {
      // Prevent the accordions from opening or closing when clicking just the link
      event.stopPropagation();
      if (!isModifiedOrPrevented(event)) {
        onClick();
      }
      event.preventDefault();
      navigateToUrl(url);
    },
    'data-test-subj': `collapsibleNavAppLink-overview`
  };
}
/**
 * Add saved object type info to recently links
 * TODO #64541 - set return type to EuiListGroupItemProps
 *
 * Recent nav links are similar to normal nav links but are missing some Kibana Platform magic and
 * because of legacy reasons have slightly different properties.
 * @param recentLink
 * @param navLinks
 * @param basePath
 */
function createRecentNavLink(recentLink, navLinks, basePath, navigateToUrl) {
  const {
    link,
    label
  } = recentLink;
  const href = (0, _to_nav_link.relativeToAbsolute)(basePath.prepend(link));
  const navLink = navLinks.find(nl => href.startsWith(nl.baseUrl));
  let titleAndAriaLabel = label;
  if (navLink) {
    titleAndAriaLabel = _i18n.i18n.translate('core.ui.recentLinks.linkItem.screenReaderLabel', {
      defaultMessage: '{recentlyAccessedItemLinklabel}, type: {pageType}',
      values: {
        recentlyAccessedItemLinklabel: label,
        pageType: navLink.title
      }
    });
  }
  return {
    href,
    label,
    title: titleAndAriaLabel,
    'aria-label': titleAndAriaLabel,
    iconType: navLink === null || navLink === void 0 ? void 0 : navLink.euiIconType,
    /* Use href and onClick to support "open in new tab" and SPA navigation in the same link */
    onClick(event) {
      if (event.button === 0 && !isModifiedOrPrevented(event)) {
        event.preventDefault();
        navigateToUrl(href);
      }
    }
  };
}