"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CollapsibleNav = CollapsibleNav;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _nav_link = require("./nav_link");
var _get_collapsible_nav_styles = require("./get_collapsible_nav_styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/chrome/browser-internal/src/ui/header/collapsible_nav.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function getAllCategories(allCategorizedLinks) {
  const allCategories = {};
  for (const [key, value] of Object.entries(allCategorizedLinks)) {
    allCategories[key] = value[0].category;
  }
  return allCategories;
}
function getOrderedCategories(mainCategories, categoryDictionary) {
  return (0, _lodash.sortBy)(Object.keys(mainCategories), categoryName => {
    var _categoryDictionary$c;
    return (_categoryDictionary$c = categoryDictionary[categoryName]) === null || _categoryDictionary$c === void 0 ? void 0 : _categoryDictionary$c.order;
  });
}
function getCategoryLocalStorageKey(id) {
  return `core.navGroup.${id}`;
}
function getIsCategoryOpen(id, storage) {
  var _storage$getItem;
  const value = (_storage$getItem = storage.getItem(getCategoryLocalStorageKey(id))) !== null && _storage$getItem !== void 0 ? _storage$getItem : 'true';
  return value === 'true';
}
function setIsCategoryOpen(id, isOpen, storage) {
  storage.setItem(getCategoryLocalStorageKey(id), `${isOpen}`);
}
const overviewIDsToHide = ['kibanaOverview'];
const overviewIDs = [...overviewIDsToHide, 'observability-overview', 'securitySolutionUI:get_started', 'management', 'enterpriseSearch'];
function CollapsibleNav({
  basePath,
  id,
  isNavOpen,
  homeHref,
  storage = window.localStorage,
  closeNav,
  navigateToApp,
  navigateToUrl,
  button,
  ...observables
}) {
  const allLinks = (0, _useObservable.default)(observables.navLinks$, []);
  const allowedLinks = (0, _react.useMemo)(() => allLinks.filter(link =>
  // Filterting out hidden links,
  link.visibleIn.includes('sideNav') &&
  // and non-data overview pages
  !overviewIDsToHide.includes(link.id)), [allLinks]);
  // Find just the integrations link
  const integrationsLink = (0, _react.useMemo)(() => allLinks.find(link => link.id === 'integrations'), [allLinks]);
  // Find all the overview (landing page) links
  const overviewLinks = (0, _react.useMemo)(() => allLinks.filter(link => overviewIDs.includes(link.id)), [allLinks]);
  const recentlyAccessed = (0, _useObservable.default)(observables.recentlyAccessed$, []);
  const customNavLink = (0, _useObservable.default)(observables.customNavLink$, undefined);
  const appId = (0, _useObservable.default)(observables.appId$, '');
  const groupedNavLinks = (0, _lodash.groupBy)(allowedLinks, link => {
    var _link$category;
    return link === null || link === void 0 ? void 0 : (_link$category = link.category) === null || _link$category === void 0 ? void 0 : _link$category.id;
  });
  const {
    undefined: unknowns = [],
    ...allCategorizedLinks
  } = groupedNavLinks;
  const categoryDictionary = getAllCategories(allCategorizedLinks);
  const orderedCategories = getOrderedCategories(allCategorizedLinks, categoryDictionary);
  const readyForEUI = (link, needsIcon = false) => {
    return (0, _nav_link.createEuiListItem)({
      link,
      appId,
      dataTestSubj: 'collapsibleNavAppLink',
      navigateToUrl,
      onClick: closeNav,
      ...(needsIcon && {
        basePath
      })
    });
  };
  const styles = (0, _get_collapsible_nav_styles.getCollapsibleNavStyles)((0, _eui.useEuiTheme)());
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNav, {
    "data-test-subj": "collapsibleNav",
    id: id,
    "aria-label": _i18n.i18n.translate('core.ui.primaryNav.screenReaderLabel', {
      defaultMessage: 'Primary'
    }),
    isOpen: isNavOpen,
    onClose: closeNav,
    button: button,
    ownFocus: false,
    size: 248,
    css: styles.navCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 5
    }
  }, customNavLink && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexShrink: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
    background: "dark",
    className: "eui-yScroll",
    style: {
      maxHeight: '40vh'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiThemeProvider, {
    colorMode: "dark",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    listItems: [(0, _nav_link.createEuiListItem)({
      link: customNavLink,
      basePath,
      navigateToUrl,
      dataTestSubj: 'collapsibleNavCustomNavLink',
      onClick: closeNav,
      externalLink: true
    })],
    maxWidth: "none",
    gutterSize: "none",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      flexShrink: 0
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 199,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
    background: "light",
    className: "eui-yScroll",
    style: {
      maxHeight: '40vh'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "aria-label": _i18n.i18n.translate('core.ui.primaryNav.pinnedLinksAriaLabel', {
      defaultMessage: 'Pinned links'
    }),
    listItems: [{
      label: 'Home',
      iconType: 'home',
      href: homeHref,
      'data-test-subj': 'homeLink',
      isActive: appId === 'home',
      onClick: event => {
        if ((0, _nav_link.isModifiedOrPrevented)(event)) {
          return;
        }
        event.preventDefault();
        closeNav();
        navigateToApp('home');
      }
    }],
    maxWidth: "none",
    color: "text",
    gutterSize: "none",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 11
    }
  }))), recentlyAccessed.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
    key: "recentlyViewed",
    background: "light",
    title: _i18n.i18n.translate('core.ui.recentlyViewed', {
      defaultMessage: 'Recently viewed'
    }),
    isCollapsible: true,
    initialIsOpen: getIsCategoryOpen('recentlyViewed', storage),
    onToggle: isCategoryOpen => setIsCategoryOpen('recentlyViewed', isCategoryOpen, storage),
    "data-test-subj": "collapsibleNavGroup-recentlyViewed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    "aria-label": _i18n.i18n.translate('core.ui.recentlyViewedAriaLabel', {
      defaultMessage: 'Recently viewed links'
    }),
    listItems: recentlyAccessed.map(link => {
      // TODO #64541
      // Can remove icon from recent links completely
      const {
        iconType,
        onClick,
        ...hydratedLink
      } = (0, _nav_link.createRecentNavLink)(link, allowedLinks, basePath, navigateToUrl);
      return {
        ...hydratedLink,
        'data-test-subj': 'collapsibleNavAppLink--recent',
        onClick: event => {
          if (!(0, _nav_link.isModifiedOrPrevented)(event)) {
            closeNav();
            onClick(event);
          }
        }
      };
    }),
    maxWidth: "none",
    color: "subdued",
    gutterSize: "none",
    size: "s",
    css: styles.navRecentsListGroupCss,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 248,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 282,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: styles.navSolutions,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 284,
      columnNumber: 7
    }
  }, orderedCategories.map(categoryName => {
    const category = categoryDictionary[categoryName];
    const overviewLink = overviewLinks.find(link => link.category === category);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
      key: category.id,
      iconType: category.euiIconType,
      iconSize: "m",
      buttonElement: overviewLink ? 'div' : 'button',
      css: styles.navSolutionGroupButton,
      title: overviewLink ? /*#__PURE__*/_react.default.createElement("a", (0, _extends2.default)({
        className: "eui-textInheritColor",
        css: styles.navSolutionGroupLink
      }, (0, _nav_link.createOverviewLink)({
        link: overviewLink,
        navigateToUrl,
        onClick: closeNav
      }), {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 299,
          columnNumber: 19
        }
      }), category.label) : category.label,
      isCollapsible: true,
      initialIsOpen: getIsCategoryOpen(category.id, storage),
      onToggle: isCategoryOpen => setIsCategoryOpen(category.id, isCategoryOpen, storage),
      "data-test-subj": `collapsibleNavGroup-${category.id}`,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 291,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
      "aria-label": _i18n.i18n.translate('core.ui.primaryNavSection.screenReaderLabel', {
        defaultMessage: 'Primary navigation links, {category}',
        values: {
          category: category.label
        }
      }),
      listItems: allCategorizedLinks[categoryName].map(link => readyForEUI(link)),
      maxWidth: "none",
      color: "subdued",
      gutterSize: "none",
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 319,
        columnNumber: 15
      }
    }));
  }), unknowns.map((link, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
    "data-test-subj": `collapsibleNavGroup-noCategory`,
    key: i,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, (0, _extends2.default)({
    color: "text",
    size: "s"
  }, readyForEUI(link, true), {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 338,
      columnNumber: 15
    }
  })))))), integrationsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 344,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 346,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCollapsibleNavGroup, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 347,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, (0, _nav_link.createEuiButtonItem)({
    link: integrationsLink,
    navigateToUrl,
    onClick: closeNav
  }), {
    fill: true,
    fullWidth: true,
    iconType: "plusInCircleFilled",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 348,
      columnNumber: 13
    }
  }), _i18n.i18n.translate('core.ui.primaryNav.addData', {
    defaultMessage: 'Add integrations'
  })))));
}