"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateTypeStatuses = calculateTypeStatuses;
exports.createWaitGroupMap = createWaitGroupMap;
exports.getIndicesInvolvedInRelocation = getIndicesInvolvedInRelocation;
exports.indexMapToIndexTypesMap = indexMapToIndexTypesMap;
exports.waitGroup = waitGroup;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _kibana_migrator_constants = require("./kibana_migrator_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// even though this utility class is present in @kbn/kibana-utils-plugin, we can't easily import it from Core
// aka. one does not simply reuse code
class Defer {
  constructor() {
    (0, _defineProperty2.default)(this, "resolve", void 0);
    (0, _defineProperty2.default)(this, "reject", void 0);
    (0, _defineProperty2.default)(this, "promise", new Promise((resolve, reject) => {
      this.resolve = resolve;
      this.reject = reject;
    }));
  }
}
function waitGroup() {
  return new Defer();
}
function createWaitGroupMap(keys) {
  if (!(keys !== null && keys !== void 0 && keys.length)) {
    return {};
  }
  const defers = keys.map(() => waitGroup());

  // every member of the WaitGroup will wait for all members to resolve
  const all = Promise.all(defers.map(({
    promise
  }) => promise));
  return keys.reduce((acc, indexName, i) => {
    const {
      resolve,
      reject
    } = defers[i];
    acc[indexName] = {
      resolve,
      reject,
      promise: all
    };
    return acc;
  }, {});
}
function getIndicesInvolvedInRelocation(currentIndexTypesMap, desiredIndexTypesMap) {
  const indicesWithRelocatingTypesSet = new Set();
  const typeIndexDistribution = calculateTypeStatuses(currentIndexTypesMap, desiredIndexTypesMap);
  Object.values(typeIndexDistribution).filter(({
    status
  }) => status === _kibana_migrator_constants.TypeStatus.Moved).forEach(({
    currentIndex,
    targetIndex
  }) => {
    indicesWithRelocatingTypesSet.add(currentIndex);
    indicesWithRelocatingTypesSet.add(targetIndex);
  });
  return Array.from(indicesWithRelocatingTypesSet);
}
function indexMapToIndexTypesMap(indexMap) {
  return Object.entries(indexMap).reduce((acc, [indexAlias, {
    typeMappings
  }]) => {
    acc[indexAlias] = Object.keys(typeMappings).sort();
    return acc;
  }, {});
}
function calculateTypeStatuses(currentIndexTypesMap, desiredIndexTypesMap) {
  const statuses = {};
  Object.entries(currentIndexTypesMap).forEach(([currentIndex, types]) => {
    types.forEach(type => {
      statuses[type] = {
        currentIndex,
        status: _kibana_migrator_constants.TypeStatus.Removed // type is removed unless we still have it
      };
    });
  });
  Object.entries(desiredIndexTypesMap).forEach(([targetIndex, types]) => {
    types.forEach(type => {
      if (!statuses[type]) {
        statuses[type] = {
          targetIndex,
          status: _kibana_migrator_constants.TypeStatus.Added // type didn't exist, it must be new
        };
      } else {
        statuses[type].targetIndex = targetIndex;
        statuses[type].status = statuses[type].currentIndex === targetIndex ? _kibana_migrator_constants.TypeStatus.Untouched : _kibana_migrator_constants.TypeStatus.Moved;
      }
    });
  });
  return statuses;
}