"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handlePageChange = exports.getSyncJobErrorsTooltip = exports.getSyncJobErrorsLabel = exports.getRunningJobsTooltip = exports.getRunningJobsLabel = exports.getRunningJobsBadgeLabel = exports.getRunningJobsBadgeAriaLabel = exports.getOrphanedJobsTooltip = exports.getOrphanedJobsLabel = exports.getIncompleteConnectorsTooltip = exports.getIncompleteConnectorsBadgeLabel = exports.getIncompleteConnectorBadgeAriaLabel = exports.getIdleJobsTooltip = exports.getIdleJobsLabel = exports.getConnectedConnectorsTooltipContent = exports.getConnectedConnectorsBadgeLabel = exports.getConnectedBadgeAriaLabel = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connectors/utils.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const getConnectedBadgeAriaLabel = connectedCount => _i18n.i18n.translate('xpack.contentConnectors.stats.connectedBadgeAriaLabel', {
  defaultMessage: '{number} Connected connectors',
  values: {
    number: connectedCount
  }
});
exports.getConnectedBadgeAriaLabel = getConnectedBadgeAriaLabel;
const getConnectedConnectorsBadgeLabel = connectedCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.connectedBadgeLabel",
  defaultMessage: "{number} Connected",
  values: {
    number: connectedCount
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 22,
    columnNumber: 3
  }
});
exports.getConnectedConnectorsBadgeLabel = getConnectedConnectorsBadgeLabel;
const getConnectedConnectorsTooltipContent = (connectedCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 34,
    columnNumber: 3
  }
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.connectedTooltip",
  defaultMessage: "{connectedCount} {completeConnectorsText} - Number of connectors successfully configured and connected in the last 30 minutes.",
  values: {
    completeConnectorsText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.connectorTooltipConnected', {
      defaultMessage: `Connected connectors`
    })),
    connectedCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 27
      }
    }, connectedCount)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.connectedCrawlerTooltip",
  defaultMessage: "{connectedCount} {completeConnectorsText} - Number of crawlers that are configured and connected.",
  values: {
    completeConnectorsText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 56,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.crawlerTooltipConnected', {
      defaultMessage: `Connected crawlers`
    })),
    connectedCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 62,
        columnNumber: 27
      }
    }, connectedCount)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 51,
    columnNumber: 7
  }
}));
exports.getConnectedConnectorsTooltipContent = getConnectedConnectorsTooltipContent;
const getIncompleteConnectorsTooltip = (incompleteCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 69,
    columnNumber: 3
  }
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.incompleteTooltip",
  defaultMessage: "{incompleteCount} {incompleteConnectorsText} - Number of connectors whose configuration is incomplete. Syncs won't be possible until the connector is fully configured and running.",
  values: {
    incompleteConnectorsText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.incompleteTooltipConnected', {
      defaultMessage: `Incomplete connectors`
    })),
    incompleteCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 82,
        columnNumber: 28
      }
    }, incompleteCount)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 71,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.incompleteCrawlerTooltip",
  defaultMessage: "{incompleteCount} {incompleteConnectorsText} - Number of crawlers whose configuration is incomplete. These crawlers are not ready to crawl.",
  values: {
    incompleteConnectorsText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.incompleteTooltipCrawler', {
      defaultMessage: `Incomplete crawlers`
    })),
    incompleteCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 28
      }
    }, incompleteCount)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 86,
    columnNumber: 7
  }
}));
exports.getIncompleteConnectorsTooltip = getIncompleteConnectorsTooltip;
const getIncompleteConnectorsBadgeLabel = incompleteCount => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.incompleteBadgeLabel",
  defaultMessage: "{incompleteCount} Incomplete",
  values: {
    incompleteCount
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 104,
    columnNumber: 3
  }
});
exports.getIncompleteConnectorsBadgeLabel = getIncompleteConnectorsBadgeLabel;
const getIncompleteConnectorBadgeAriaLabel = incompleteCount => _i18n.i18n.translate('xpack.contentConnectors.stats.incompleteBadgeAriaLabel', {
  defaultMessage: '{incompleteCount} Incomplete connectors',
  values: {
    incompleteCount
  }
});
exports.getIncompleteConnectorBadgeAriaLabel = getIncompleteConnectorBadgeAriaLabel;
const getRunningJobsLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.stats.runningSyncsTextLabel', {
  defaultMessage: '{syncs} running syncs',
  values: {
    syncs: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.contentConnectors.stats.runningCrawlsTextLabel', {
  defaultMessage: '{syncs} running crawls',
  values: {
    syncs: inProgressCount
  }
});
exports.getRunningJobsLabel = getRunningJobsLabel;
const getRunningJobsTooltip = (inProgressCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 134,
    columnNumber: 3
  }
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.runningTooltip",
  defaultMessage: "{inProgressCount} {runningCountText} - Number of running sync jobs. This includes idle syncs.",
  values: {
    inProgressCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 28
      }
    }, inProgressCount),
    runningCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.connectorTooltipRunning', {
      defaultMessage: `Running syncs`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 136,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.runningCrawlerTooltip",
  defaultMessage: "{inProgressCount} {runningCountText} - Number of running crawls",
  values: {
    inProgressCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 28
      }
    }, inProgressCount),
    runningCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 157,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.crawlerTooltipRunning', {
      defaultMessage: `Running crawls`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 151,
    columnNumber: 7
  }
}));
exports.getRunningJobsTooltip = getRunningJobsTooltip;
const getRunningJobsBadgeAriaLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.stats.runningBadgeAriaLabel', {
  defaultMessage: '{number} Running syncs.',
  values: {
    number: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.contentConnectors.stats.runningCrawlerBadgeAriaLabel', {
  defaultMessage: '{number} Running crawls.',
  values: {
    number: inProgressCount
  }
});
exports.getRunningJobsBadgeAriaLabel = getRunningJobsBadgeAriaLabel;
const getRunningJobsBadgeLabel = (inProgressCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.stats.runningBadgeLabel', {
  defaultMessage: '{number} Running syncs',
  values: {
    number: inProgressCount
  }
}) : _i18n.i18n.translate('xpack.contentConnectors.stats.runningCrawlerBadgeLabel', {
  defaultMessage: '{number} Running crawls',
  values: {
    number: inProgressCount
  }
});
exports.getRunningJobsBadgeLabel = getRunningJobsBadgeLabel;
const getIdleJobsLabel = idleCount => _i18n.i18n.translate('xpack.contentConnectors.stats.idleJobsText', {
  defaultMessage: '{idleCount} Idle syncs',
  values: {
    idleCount
  }
});
exports.getIdleJobsLabel = getIdleJobsLabel;
const getIdleJobsTooltip = idleCount => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 204,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.idleTooltip",
  defaultMessage: "{idleCount} {idleCountText} - Number of sync jobs which are still running but have not seen any update from the backend connector for more than 1 minute",
  values: {
    idleCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 20
      }
    }, idleCount),
    idleCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 211,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.connectorTooltipIdle', {
      defaultMessage: `Idle syncs`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 205,
    columnNumber: 5
  }
}));
exports.getIdleJobsTooltip = getIdleJobsTooltip;
const getOrphanedJobsTooltip = (orphanedCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 222,
    columnNumber: 3
  }
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.orphanedTooltip",
  defaultMessage: "{orphanedCount} {orphanedCountText} - Number of sync jobs whose associated connector can't be found. The connector might have been deleted.",
  values: {
    orphanedCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 228,
        columnNumber: 26
      }
    }, orphanedCount),
    orphanedCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 230,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.connectorTooltipOrphaned', {
      defaultMessage: `Orphaned syncs`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 224,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.orphanedCrawlerTooltip",
  defaultMessage: "{orphanedCount} {orphanedCountText} - Number of crawl jobs whose associated crawler can't be found. The crawler might have been deleted.",
  values: {
    orphanedCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 243,
        columnNumber: 26
      }
    }, orphanedCount),
    orphanedCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.crawlerTooltipOrphaned', {
      defaultMessage: `Orphaned crawls`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 239,
    columnNumber: 7
  }
}));
exports.getOrphanedJobsTooltip = getOrphanedJobsTooltip;
const getOrphanedJobsLabel = (orphanedCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.stats.orphanedBadgeAriaLabel', {
  defaultMessage: '{number} Orphaned syncs.',
  values: {
    number: orphanedCount
  }
}) : _i18n.i18n.translate('xpack.contentConnectors.stats.orphanedCrawlerBadgeAriaLabel', {
  defaultMessage: '{number} Orphaned crawls.',
  values: {
    number: orphanedCount
  }
});
exports.getOrphanedJobsLabel = getOrphanedJobsLabel;
const getSyncJobErrorsTooltip = (errorCount, isCrawler) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 271,
    columnNumber: 3
  }
}, !isCrawler ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.errorTooltip",
  defaultMessage: "{errorCount} {errorCountText} - Number of connectors whose last full sync failed",
  values: {
    errorCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 277,
        columnNumber: 23
      }
    }, errorCount),
    errorCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 279,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.connectorTooltipError', {
      defaultMessage: `Sync errors`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 273,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.contentConnectors.connectorStats.errorCrawlerTooltip",
  defaultMessage: "{errorCount} {errorCountText} - Number of crawlers whose last crawl failed",
  values: {
    errorCount: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 292,
        columnNumber: 23
      }
    }, errorCount),
    errorCountText: /*#__PURE__*/_react.default.createElement("b", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 294,
        columnNumber: 13
      }
    }, _i18n.i18n.translate('xpack.contentConnectors.stats.crawlerTooltipError', {
      defaultMessage: `Crawl errors`
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 288,
    columnNumber: 7
  }
}));
exports.getSyncJobErrorsTooltip = getSyncJobErrorsTooltip;
const getSyncJobErrorsLabel = (errorCount, isCrawler) => !isCrawler ? _i18n.i18n.translate('xpack.contentConnectors.stats.errorBadgeLabel', {
  defaultMessage: '{number} Sync errors',
  values: {
    number: errorCount
  }
}) : _i18n.i18n.translate('xpack.contentConnectors.stats.errorCrawlerBadgeLabel', {
  defaultMessage: '{number} Crawl errors',
  values: {
    number: errorCount
  }
});
exports.getSyncJobErrorsLabel = getSyncJobErrorsLabel;
const handlePageChange = paginationCallback => ({
  page: {
    index
  }
}) => {
  paginationCallback(index + 1);
};
exports.handlePageChange = handlePageChange;