"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updatePipeline = exports.UpdatePipelineApiLogic = void 0;
var _i18n = require("@kbn/i18n");
var _create_api_logic = require("../api_logic/create_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updatePipeline = async ({
  connectorId,
  pipeline,
  http
}) => {
  const route = `/internal/content_connectors/connectors/${connectorId}/pipeline`;
  await (http === null || http === void 0 ? void 0 : http.put(route, {
    body: JSON.stringify(pipeline)
  }));
  return {
    connectorId,
    pipeline
  };
};
exports.updatePipeline = updatePipeline;
const UpdatePipelineApiLogic = exports.UpdatePipelineApiLogic = (0, _create_api_logic.createApiLogic)(['content', 'update_pipeline_api_logic'], updatePipeline, {
  showSuccessFlashFn: () => _i18n.i18n.translate('xpack.contentConnectors.content.indices.pipelines.successToast.title', {
    defaultMessage: 'Pipelines updated'
  })
});