"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useResizeCheckerUtils = void 0;
var _react = require("react");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Hook that returns functions for setting up and destroying a {@link ResizeChecker}
 * for a Monaco editor.
 */
const useResizeCheckerUtils = () => {
  const resizeChecker = (0, _react.useRef)(null);
  const setupResizeChecker = (divElement, editor) => {
    if (resizeChecker.current) {
      resizeChecker.current.destroy();
    }
    resizeChecker.current = new _public.ResizeChecker(divElement);
    resizeChecker.current.on('resize', () => {
      editor.layout();
    });
  };
  const destroyResizeChecker = () => {
    resizeChecker.current.destroy();
  };
  return {
    setupResizeChecker,
    destroyResizeChecker
  };
};
exports.useResizeCheckerUtils = useResizeCheckerUtils;