"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PAGER_DUTY_API_URL = exports.EVENT_ACTION_TRIGGER = exports.EVENT_ACTION_RESOLVE = exports.EVENT_ACTION_ACKNOWLEDGE = exports.EVENT_ACTIONS_WITH_REQUIRED_DEDUPKEY = exports.CONNECTOR_NAME = exports.CONNECTOR_ID = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const CONNECTOR_ID = exports.CONNECTOR_ID = '.pagerduty';
const CONNECTOR_NAME = exports.CONNECTOR_NAME = _i18n.i18n.translate('connectors.pagerduty.title', {
  defaultMessage: 'PagerDuty'
});

// uses the PagerDuty Events API v2
// https://v2.developer.pagerduty.com/docs/events-api-v2
const PAGER_DUTY_API_URL = exports.PAGER_DUTY_API_URL = 'https://events.pagerduty.com/v2/enqueue';
const EVENT_ACTION_TRIGGER = exports.EVENT_ACTION_TRIGGER = 'trigger';
const EVENT_ACTION_RESOLVE = exports.EVENT_ACTION_RESOLVE = 'resolve';
const EVENT_ACTION_ACKNOWLEDGE = exports.EVENT_ACTION_ACKNOWLEDGE = 'acknowledge';
const EVENT_ACTIONS_WITH_REQUIRED_DEDUPKEY = exports.EVENT_ACTIONS_WITH_REQUIRED_DEDUPKEY = new Set([EVENT_ACTION_RESOLVE, EVENT_ACTION_ACKNOWLEDGE]);