"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.groupStatsRenderer = exports.groupPanelRenderer = exports.ComplianceBarComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _constants = require("../../../common/constants");
var _cloud_security_grouping = require("../../../components/cloud_security_grouping");
var _cis_benchmark_icon = require("../../../components/cis_benchmark_icon");
var _compliance_score_bar = require("../../../components/compliance_score_bar");
var _constants2 = require("./constants");
var _test_subjects = require("../test_subjects");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/pages/configurations/latest_findings/latest_findings_group_renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const groupPanelRenderer = (selectedGroup, bucket, nullGroupMessage, isLoading) => {
  var _bucket$benchmarkId, _bucket$benchmarkId$b, _bucket$benchmarkId$b2, _bucket$resourceName, _bucket$resourceName$, _bucket$resourceName$2, _bucket$resourceSubTy, _bucket$resourceSubTy2, _bucket$resourceSubTy3, _bucket$benchmarkName, _bucket$benchmarkName2, _bucket$benchmarkName3, _bucket$benchmarkVers, _bucket$benchmarkVers2, _bucket$benchmarkVers3, _bucket$benchmarkName4, _bucket$benchmarkName5, _bucket$benchmarkName6, _bucket$benchmarkName7, _bucket$benchmarkName8, _bucket$benchmarkName9, _bucket$benchmarkName10, _bucket$benchmarkName11, _bucket$benchmarkName12, _bucket$benchmarkName13, _bucket$benchmarkName14, _bucket$benchmarkName15;
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement(_cloud_security_grouping.LoadingGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    });
  }
  const benchmarkId = (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkId = bucket.benchmarkId) === null || _bucket$benchmarkId === void 0 ? void 0 : (_bucket$benchmarkId$b = _bucket$benchmarkId.buckets) === null || _bucket$benchmarkId$b === void 0 ? void 0 : (_bucket$benchmarkId$b2 = _bucket$benchmarkId$b[0]) === null || _bucket$benchmarkId$b2 === void 0 ? void 0 : _bucket$benchmarkId$b2.key);
  const renderNullGroup = title => /*#__PURE__*/_react.default.createElement(_cloud_security_grouping.NullGroup, {
    title: title,
    field: selectedGroup,
    unit: _constants2.NULL_GROUPING_UNIT,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
  switch (selectedGroup) {
    case _constants.FINDINGS_GROUPING_OPTIONS.RESOURCE_ID:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.RESOURCE_NAME) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 54,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: (0, _react2.css)`
                  display: inline;
                `,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 62,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextBlockTruncate, {
        lines: 2,
        css: (0, _react2.css)`
                      word-break: break-all;
                    `,
        title: (_bucket$resourceName = bucket.resourceName) === null || _bucket$resourceName === void 0 ? void 0 : (_bucket$resourceName$ = _bucket$resourceName.buckets) === null || _bucket$resourceName$ === void 0 ? void 0 : (_bucket$resourceName$2 = _bucket$resourceName$[0]) === null || _bucket$resourceName$2 === void 0 ? void 0 : _bucket$resourceName$2.key,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 63,
          columnNumber: 19
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket, 'resourceName')))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 74,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 17
        }
      }, (_bucket$resourceSubTy = bucket.resourceSubType) === null || _bucket$resourceSubTy === void 0 ? void 0 : (_bucket$resourceSubTy2 = _bucket$resourceSubTy.buckets) === null || _bucket$resourceSubTy2 === void 0 ? void 0 : (_bucket$resourceSubTy3 = _bucket$resourceSubTy2[0]) === null || _bucket$resourceSubTy3 === void 0 ? void 0 : _bucket$resourceSubTy3.key)))));
    case _constants.FINDINGS_GROUPING_OPTIONS.RULE_NAME:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.RULE_NAME) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 88,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 89,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 17
        }
      }, " ", (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 93,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 94,
          columnNumber: 17
        }
      }, (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName = bucket.benchmarkName) === null || _bucket$benchmarkName === void 0 ? void 0 : (_bucket$benchmarkName2 = _bucket$benchmarkName.buckets) === null || _bucket$benchmarkName2 === void 0 ? void 0 : (_bucket$benchmarkName3 = _bucket$benchmarkName2[0]) === null || _bucket$benchmarkName3 === void 0 ? void 0 : _bucket$benchmarkName3.key), ' ', (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkVers = bucket.benchmarkVersion) === null || _bucket$benchmarkVers === void 0 ? void 0 : (_bucket$benchmarkVers2 = _bucket$benchmarkVers.buckets) === null || _bucket$benchmarkVers2 === void 0 ? void 0 : (_bucket$benchmarkVers3 = _bucket$benchmarkVers2[0]) === null || _bucket$benchmarkVers3 === void 0 ? void 0 : _bucket$benchmarkVers3.key))))));
    case _constants.FINDINGS_GROUPING_OPTIONS.CLOUD_ACCOUNT_ID:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.CLOUD_ACCOUNT_NAME) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 107,
          columnNumber: 9
        }
      }, benchmarkId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 109,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName4 = bucket.benchmarkName) === null || _bucket$benchmarkName4 === void 0 ? void 0 : (_bucket$benchmarkName5 = _bucket$benchmarkName4.buckets) === null || _bucket$benchmarkName5 === void 0 ? void 0 : (_bucket$benchmarkName6 = _bucket$benchmarkName5[0]) === null || _bucket$benchmarkName6 === void 0 ? void 0 : _bucket$benchmarkName6.key),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 110,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 116,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 17
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket, 'accountName'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 121,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 122,
          columnNumber: 17
        }
      }, (_bucket$benchmarkName7 = bucket.benchmarkName) === null || _bucket$benchmarkName7 === void 0 ? void 0 : (_bucket$benchmarkName8 = _bucket$benchmarkName7.buckets) === null || _bucket$benchmarkName8 === void 0 ? void 0 : (_bucket$benchmarkName9 = _bucket$benchmarkName8[0]) === null || _bucket$benchmarkName9 === void 0 ? void 0 : _bucket$benchmarkName9.key)))));
    case _constants.FINDINGS_GROUPING_OPTIONS.ORCHESTRATOR_CLUSTER_ID:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.ORCHESTRATOR_CLUSTER_ID) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 134,
          columnNumber: 9
        }
      }, benchmarkId && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: 0,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 136,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_cis_benchmark_icon.CISBenchmarkIcon, {
        type: benchmarkId,
        name: (0, _cloud_security_grouping.firstNonNullValue)((_bucket$benchmarkName10 = bucket.benchmarkName) === null || _bucket$benchmarkName10 === void 0 ? void 0 : (_bucket$benchmarkName11 = _bucket$benchmarkName10.buckets) === null || _bucket$benchmarkName11 === void 0 ? void 0 : (_bucket$benchmarkName12 = _bucket$benchmarkName11[0]) === null || _bucket$benchmarkName12 === void 0 ? void 0 : _bucket$benchmarkName12.key),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 15
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 17
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket, 'clusterName'))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 17
        }
      }, (_bucket$benchmarkName13 = bucket.benchmarkName) === null || _bucket$benchmarkName13 === void 0 ? void 0 : (_bucket$benchmarkName14 = _bucket$benchmarkName13.buckets) === null || _bucket$benchmarkName14 === void 0 ? void 0 : (_bucket$benchmarkName15 = _bucket$benchmarkName14[0]) === null || _bucket$benchmarkName15 === void 0 ? void 0 : _bucket$benchmarkName15.key)))));
    default:
      return nullGroupMessage ? renderNullGroup(_constants2.NULL_GROUPING_MESSAGES.DEFAULT) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        direction: "column",
        gutterSize: "none",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 163,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 165,
          columnNumber: 17
        }
      }, (0, _cloudSecurityPosture.getGroupPanelTitle)(bucket))))));
  }
};
exports.groupPanelRenderer = groupPanelRenderer;
const FindingsCountComponent = ({
  bucket
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: bucket.doc_count,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    css: (0, _react2.css)`
          margin-left: ${euiTheme.size.s};
        `,
    color: "hollow",
    "data-test-subj": _test_subjects.FINDINGS_GROUPING_COUNTER,
    tabIndex: 0,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 7
    }
  }, (0, _cloudSecurityPostureCommon.getAbbreviatedNumber)(bucket.doc_count)));
};
const FindingsCount = /*#__PURE__*/_react.default.memo(FindingsCountComponent);
const ComplianceBarComponent = ({
  bucket
}) => {
  var _bucket$failedFinding, _bucket$passedFinding;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const totalFailed = ((_bucket$failedFinding = bucket.failedFindings) === null || _bucket$failedFinding === void 0 ? void 0 : _bucket$failedFinding.doc_count) || 0;
  const totalPassed = ((_bucket$passedFinding = bucket.passedFindings) === null || _bucket$passedFinding === void 0 ? void 0 : _bucket$passedFinding.doc_count) || 0;
  return /*#__PURE__*/_react.default.createElement(_compliance_score_bar.ComplianceScoreBar, {
    size: "l",
    overrideCss: (0, _react2.css)`
        width: 104px;
        margin-left: ${euiTheme.size.s};
      `,
    totalFailed: totalFailed,
    totalPassed: totalPassed,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 5
    }
  });
};
exports.ComplianceBarComponent = ComplianceBarComponent;
const ComplianceBar = /*#__PURE__*/_react.default.memo(ComplianceBarComponent);
const groupStatsRenderer = (selectedGroup, bucket) => [{
  title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.findings', {
    defaultMessage: 'Findings'
  }),
  component: /*#__PURE__*/_react.default.createElement(FindingsCount, {
    bucket: bucket,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 16
    }
  })
}, {
  title: _i18n.i18n.translate('xpack.csp.findings.grouping.stats.badges.compliance', {
    defaultMessage: 'Compliance'
  }),
  component: /*#__PURE__*/_react.default.createElement(ComplianceBar, {
    bucket: bucket,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 233,
      columnNumber: 16
    }
  })
}];
exports.groupStatsRenderer = groupStatsRenderer;