"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAbbreviatedNumber = void 0;
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns an abbreviated number when the value is greater than or equal to 1000.
 * The abbreviated number is formatted using numeral:
 * - thousand: k
 * - million: m
 * - billion: b
 * - trillion: t
 * */
const getAbbreviatedNumber = value => {
  if (isNaN(value)) {
    return 0;
  }
  return value < 1000 ? value : (0, _numeral.default)(value).format('0.0a');
};
exports.getAbbreviatedNumber = getAbbreviatedNumber;