"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectTelemetryService = void 0;
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class CloudConnectTelemetryService {
  constructor(analytics) {
    this.analytics = analytics;
  }
  trackClusterConnected() {
    this.analytics.reportEvent(_constants.CLOUD_CONNECT_CLUSTER_CONNECTED, {});
  }
  trackClusterDisconnected() {
    this.analytics.reportEvent(_constants.CLOUD_CONNECT_CLUSTER_DISCONNECTED, {});
  }
  trackServiceEnabled(params) {
    this.analytics.reportEvent(_constants.CLOUD_CONNECT_SERVICE_ENABLED, params);
  }
  trackServiceDisabled(params) {
    this.analytics.reportEvent(_constants.CLOUD_CONNECT_SERVICE_DISABLED, params);
  }
  trackLinkClicked(params) {
    this.analytics.reportEvent(_constants.CLOUD_CONNECT_LINK_CLICKED, params);
  }
}
exports.CloudConnectTelemetryService = CloudConnectTelemetryService;