"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CloudConnectApiService = void 0;
var _shared_imports = require("../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const API_BASE_PATH = '/internal/cloud_connect';
class CloudConnectApiService {
  constructor(client) {
    this.client = client;
  }
  useRequest(config) {
    return (0, _shared_imports.useRequest)(this.client, config);
  }
  async sendRequest(config) {
    return await (0, _shared_imports.sendRequest)(this.client, config);
  }
  useLoadConfig() {
    return this.useRequest({
      path: `${API_BASE_PATH}/config`,
      method: 'get'
    });
  }
  useLoadClusterDetails() {
    return this.useRequest({
      path: `${API_BASE_PATH}/cluster_details`,
      method: 'get'
    });
  }
  async authenticate(apiKey) {
    return await this.sendRequest({
      path: `${API_BASE_PATH}/authenticate`,
      method: 'post',
      body: JSON.stringify({
        apiKey
      })
    });
  }
  async updateServices(services) {
    return await this.sendRequest({
      path: `${API_BASE_PATH}/cluster_details`,
      method: 'put',
      body: JSON.stringify({
        services
      })
    });
  }
  async disconnectCluster() {
    return await this.sendRequest({
      path: `${API_BASE_PATH}/cluster`,
      method: 'delete'
    });
  }
}
exports.CloudConnectApiService = CloudConnectApiService;