"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBreadcrumbs = void 0;
var _react = require("react");
var _app_context = require("../app_context");
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBreadcrumbs = () => {
  const {
    chrome
  } = (0, _app_context.useCloudConnectedAppContext)();
  (0, _react.useEffect)(() => {
    const breadcrumbs = [{
      text: 'Kibana',
      href: '/'
    }, {
      text: _common.PLUGIN_NAME
    }];
    chrome.setBreadcrumbs(breadcrumbs);
    chrome.docTitle.change(_common.PLUGIN_NAME);
  }, [chrome]);
};
exports.useBreadcrumbs = useBreadcrumbs;