"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServiceCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _app_context = require("../../../app_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cloud_connect/public/application/components/connected_services/services_section/details_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ServiceCard = ({
  serviceKey,
  title,
  enabled,
  supported = true,
  badge,
  badgeTooltip,
  region,
  description,
  learnMoreUrl,
  serviceUrl,
  enableServiceByUrl,
  onEnable,
  onDisable,
  onOpen,
  isLoading = false,
  isCardDisabled = false,
  subscriptionRequired = false,
  hasActiveSubscription = true
}) => {
  const {
    hasConfigurePermission,
    telemetryService
  } = (0, _app_context.useCloudConnectedAppContext)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const closePopover = () => setIsPopoverOpen(false);
  const togglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const renderBadge = () => {
    if (isCardDisabled && badge) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
        size: "s",
        label: badge,
        "data-test-subj": "serviceCardComingSoonBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 81,
          columnNumber: 14
        }
      });
    }
    if (!supported) {
      const unsupportedBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "serviceCardUnsupportedBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 86,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.unsupported",
        defaultMessage: "Unsupported",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 87,
          columnNumber: 11
        }
      }));
      if (badgeTooltip) {
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: badgeTooltip,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 95,
            columnNumber: 16
          }
        }, unsupportedBadge);
      }
      return unsupportedBadge;
    }
    if (badge) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "serviceCardCustomBadge",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 9
        }
      }, badge);
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
      color: enabled ? 'success' : 'subdued',
      "data-test-subj": enabled ? 'serviceCardEnabledBadge' : 'serviceCardDisabledBadge',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 7
      }
    }, enabled ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.enabled",
      defaultMessage: "Enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 11
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.notEnabled",
      defaultMessage: "Not enabled",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 11
      }
    }));
  };
  const renderActions = () => {
    if (isCardDisabled || !supported) {
      return null;
    }

    // Show subscription requirement message if service requires subscription and there's no active subscription
    if (subscriptionRequired && !hasActiveSubscription) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        "data-test-subj": "serviceCardSubscriptionMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 137,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 143,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.requiresSubscription",
        defaultMessage: "Requires an active cloud subscription",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 151,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.subscriptionInfo', {
          defaultMessage: 'Contact your admin to subscribe to Elastic Cloud.'
        }),
        position: "top",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 152,
          columnNumber: 13
        }
      })));
    }

    // Show permission message if user doesn't have configure permission
    if (!hasConfigurePermission) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs",
        alignItems: "center",
        responsive: false,
        "data-test-subj": "serviceCardPermissionMessage",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 169,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "subdued",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 176,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.onlyAdminsCanManage",
        defaultMessage: "Only admins can manage services",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 177,
          columnNumber: 15
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.contactAdmin', {
          defaultMessage: 'Contact your admin'
        }),
        position: "top",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 184,
          columnNumber: 13
        }
      })));
    }
    if (enabled) {
      const moreActionsButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        iconType: "boxesHorizontal",
        "aria-label": _i18n.i18n.translate('xpack.cloudConnect.connectedServices.service.moreActions', {
          defaultMessage: 'More actions'
        }),
        size: "s",
        display: "empty",
        onClick: togglePopover,
        isLoading: isLoading,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 197,
          columnNumber: 9
        }
      });
      const menuItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: "disable",
        onClick: () => {
          closePopover();
          if (onDisable) {
            onDisable();
          }
        },
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 210,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        color: "danger",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 219,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.disable",
        defaultMessage: "Disable service",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 220,
          columnNumber: 13
        }
      })))];
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s",
        responsive: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 9
        }
      }, serviceUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        href: serviceUrl,
        target: "_blank",
        iconSide: "right",
        iconType: "popout",
        onClick: () => {
          // Track telemetry for opening service
          if (serviceKey) {
            telemetryService.trackLinkClicked({
              destination_type: 'service_portal',
              service_type: serviceKey
            });
          }
          if (onOpen) {
            onOpen();
          }
        },
        disabled: isLoading,
        isLoading: isLoading,
        "data-test-subj": "serviceCardOpenButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 232,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.open",
        defaultMessage: "Open",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 254,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 261,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        button: moreActionsButton,
        isOpen: isPopoverOpen,
        closePopover: closePopover,
        panelPaddingSize: "none",
        anchorPosition: "downRight",
        "data-test-subj": "serviceCardMoreActionsPopover",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 262,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
        items: menuItems,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 270,
          columnNumber: 15
        }
      }))));
    }

    // Show external link icon if service is enabled via URL
    if (enableServiceByUrl) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "s",
        onClick: onEnable,
        disabled: !onEnable || isLoading,
        isLoading: isLoading,
        iconType: "popout",
        iconSide: "right",
        "data-test-subj": "serviceCardConnectButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 280,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.cloudConnect.connectedServices.service.connect",
        defaultMessage: "Connect",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 289,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "s",
      onClick: onEnable,
      disabled: !onEnable || isLoading,
      isLoading: isLoading,
      "data-test-subj": "serviceCardConnectButton",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 298,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.cloudConnect.connectedServices.service.connect",
      defaultMessage: "Connect",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 305,
        columnNumber: 9
      }
    }));
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    color: isCardDisabled ? 'subdued' : 'plain',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 314,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "flexStart",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 315,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 17
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 323,
      columnNumber: 13
    }
  }, renderBadge())), region && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 328,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 329,
      columnNumber: 15
    }
  }, region)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 335,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 336,
      columnNumber: 11
    }
  }, description, ' ', learnMoreUrl && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: learnMoreUrl,
    target: "_blank",
    external: true,
    onClick: () => {
      // Track telemetry for learn more link
      if (serviceKey) {
        telemetryService.trackLinkClicked({
          destination_type: 'service_documentation',
          service_type: serviceKey
        });
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 339,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.cloudConnect.connectedServices.service.learnMore",
    defaultMessage: "Learn more",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 353,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 362,
      columnNumber: 9
    }
  }, renderActions())));
};
exports.ServiceCard = ServiceCard;