"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getColorCategories = getColorCategories;
exports.getLegacyColorCategories = getLegacyColorCategories;
var _common = require("@kbn/data-plugin/common");
var _coloring = require("@kbn/coloring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * Returns all serialized categories of the dataset for color matching.
 * All non-serializable fields will be as a plain unformatted string.
 *
 * Note: This does **NOT** support transposed columns
 */
function getColorCategories(rows = [], accessor, exclude, legacyMode = false // stringifies raw values
) {
  if (!accessor) return [];
  const seen = new Set();
  return rows.reduce((acc, row) => {
    const hasValue = Object.hasOwn(row, accessor);
    const rawValue = row[accessor];
    const key = (0, _coloring.getValueKey)(rawValue);
    if (hasValue && !(exclude !== null && exclude !== void 0 && exclude.includes(rawValue)) && !seen.has(key)) {
      const value = (0, _common.serializeField)(rawValue);
      seen.add(key);
      acc.push(legacyMode ? key : value);
    }
    return acc;
  }, []);
}

/**
 * Returns all *stringified* categories of the dataset for color matching.
 *
 * Should **only** be used with legacy `palettes`
 */
function getLegacyColorCategories(rows, accessor, exclude) {
  return getColorCategories(rows, accessor, exclude, true).map(String);
}