/*! Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one or more contributor license agreements.
 * Licensed under the Elastic License 2.0; you may not use this file except in compliance with the Elastic License 2.0. */
"use strict";(self.cases_bundle_jsonpfunction=self.cases_bundle_jsonpfunction||[]).push([[678],{9380:(e,a,t)=>{t.d(a,{B:()=>i});var s=t(5008);const i={defaultPickerLabel:s.i18n.translate("sharedUXPackages.fileUpload.defaultFilePickerLabel",{defaultMessage:"Upload a file"}),fileEmpty:s.i18n.translate("sharedUXPackages.fileUpload.fileEmptyErrorMessage",{defaultMessage:"File is empty. Please provide a file with content."}),upload:s.i18n.translate("sharedUXPackages.fileUpload.uploadButtonLabel",{defaultMessage:"Upload"}),uploading:s.i18n.translate("sharedUXPackages.fileUpload.uploadingButtonLabel",{defaultMessage:"Uploading"}),uploadComplete:s.i18n.translate("sharedUXPackages.fileUpload.uploadCompleteButtonLabel",{defaultMessage:"Upload complete"}),retry:s.i18n.translate("sharedUXPackages.fileUpload.retryButtonLabel",{defaultMessage:"Retry"}),clear:s.i18n.translate("sharedUXPackages.fileUpload.clearButtonLabel",{defaultMessage:"Clear"}),cancel:s.i18n.translate("sharedUXPackages.fileUpload.cancelButtonLabel",{defaultMessage:"Cancel"}),uploadDone:s.i18n.translate("sharedUXPackages.fileUpload.uploadDoneToolTipContent",{defaultMessage:"Your file was successfully uploaded!"}),fileTooLarge:e=>s.i18n.translate("sharedUXPackages.fileUpload.fileTooLargeErrorMessage",{defaultMessage:"File is too large. Maximum size is {expectedSize, plural, one {# byte} other {# bytes} }.",values:{expectedSize:e}}),mimeTypeNotSupported:(e,a)=>s.i18n.translate("sharedUXPackages.fileUpload.mimeTypeNotSupportedErrorMessage",{defaultMessage:'File mime type "{mimeType}" is not supported. Supported mime types are: {supportedMimeTypes}.',values:{mimeType:e,supportedMimeTypes:a}})}},6177:(e,a,t)=>{t.d(a,{L:()=>h});var s=t(8915),i=t(190),n=["0","1","2","3","4","5","6","7","8","9","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","#","$","%","*","+",",","-",".",":",";","=","?","@","[","]","^","_","{","|","}","~"],l=(e,a)=>{var t="";for(let s=1;s<=a;s++){let i=Math.floor(e)/Math.pow(83,a-s)%83;t+=n[Math.floor(i)]}return t},r=e=>{let a=e/255;return a<=.04045?a/12.92:Math.pow((a+.055)/1.055,2.4)},o=e=>{let a=Math.max(0,Math.min(1,e));return a<=.0031308?Math.trunc(12.92*a*255+.5):Math.trunc(255*(1.055*Math.pow(a,.4166666666666667)-.055)+.5)},d=(e,a)=>(e=>e<0?-1:1)(e)*Math.pow(Math.abs(e),a),c=class extends Error{constructor(e){super(e),this.name="ValidationError",this.message=e}},u=(e,a,t,s)=>{let i=0,n=0,l=0,o=4*a;for(let d=0;d<a;d++){let a=4*d;for(let c=0;c<t;c++){let t=a+c*o,u=s(d,c);i+=u*r(e[t]),n+=u*r(e[t+1]),l+=u*r(e[t+2])}}let d=1/(a*t);return[i*d,n*d,l*d]},p=(e,a,t,s,i)=>{if(s<1||s>9||i<1||i>9)throw new c("BlurHash must have between 1 and 9 components");if(a*t*4!==e.length)throw new c("Width and height must match the pixels array");let n=[];for(let l=0;l<i;l++)for(let i=0;i<s;i++){let s=0==i&&0==l?1:2,r=u(e,a,t,((e,n)=>s*Math.cos(Math.PI*i*e/a)*Math.cos(Math.PI*l*n/t)));n.push(r)}let r,p=n[0],f=n.slice(1),g="";if(g+=l(s-1+9*(i-1),1),f.length>0){let e=Math.max(...f.map((e=>Math.max(...e)))),a=Math.floor(Math.max(0,Math.min(82,Math.floor(166*e-.5))));r=(a+1)/166,g+=l(a,1)}else r=1,g+=l(0,1);return g+=l((e=>(o(e[0])<<16)+(o(e[1])<<8)+o(e[2]))(p),4),f.forEach((e=>{g+=l(((e,a)=>19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*d(e[0]/a,.5)+9.5))))*19+19*Math.floor(Math.max(0,Math.min(18,Math.floor(9*d(e[1]/a,.5)+9.5))))+Math.floor(Math.max(0,Math.min(18,Math.floor(9*d(e[2]/a,.5)+9.5)))))(e,r),2)})),g};async function f(e){const a=window.URL.createObjectURL(e);try{const e=await(t=a,new Promise(((e,a)=>{const s=new window.Image;s.src=t,s.onload=()=>e(s),s.onerror=a}))),s=document.createElement("canvas"),{width:i,height:n}=function(e,a){const t=Math.abs(Math.min(Math.min(120/e,120/a),1)-1);return{width:Math.floor(e-t*e),height:Math.floor(a-t*a)}}(e.width,e.height);s.width=i,s.height=n;const l=s.getContext("2d");if(!l)throw new Error("Could not get 2d canvas context!");l.drawImage(e,0,0,i,n);const r=l.getImageData(0,0,i,n);return{blurhash:p(r.data,r.width,r.height,4,4),width:e.width,height:e.height}}catch(e){return}finally{window.URL.revokeObjectURL(a)}var t}var g=t(9380),m=t(770);class SimpleStateSubject extends i.BehaviorSubject{constructor(e){super(e)}getSnapshot(){return this.getValue()}setState(e){this.next((0,m.merge)({},this.getSnapshot(),e))}}class UploadState{constructor(e,a,t={allowRepeatedUploads:!1},n=f){(0,s.default)(this,"abort$",new i.Subject),(0,s.default)(this,"files$$",new i.BehaviorSubject([])),(0,s.default)(this,"files$",this.files$$.pipe(i.switchMap((e=>e.length?i.zip(...e):i.of([]))))),(0,s.default)(this,"clear$",new i.Subject),(0,s.default)(this,"error$",new i.BehaviorSubject(void 0)),(0,s.default)(this,"uploading$",new i.BehaviorSubject(!1)),(0,s.default)(this,"done$",new i.Subject),(0,s.default)(this,"subscriptions",void 0),(0,s.default)(this,"validateFile",(e=>{const a=this.fileKind;if(!e.size)throw new Error(g.B.fileEmpty);if(null!=a.maxSizeBytes&&e.size>this.fileKind.maxSizeBytes){const e=g.B.fileTooLarge(String(this.fileKind.maxSizeBytes));throw new Error(e)}if(null!=a.allowedMimeTypes&&!a.allowedMimeTypes.includes(e.type)){const t=g.B.mimeTypeNotSupported(e.type,a.allowedMimeTypes.join(", "));throw new Error(t)}})),(0,s.default)(this,"setFiles",(e=>{if(this.isUploading())throw new Error("Cannot update files while uploading");let a;e.length||(this.done$.next(void 0),this.error$.next(void 0));try{e.forEach(this.validateFile)}catch(e){a=e}this.files$$.next(e.map((e=>new SimpleStateSubject({file:e,status:"idle",error:a}))))})),(0,s.default)(this,"abort",(()=>{if(!this.isUploading())throw new Error("No upload in progress");this.abort$.next()})),(0,s.default)(this,"clear",(()=>{this.setFiles([]),this.clear$.next()})),(0,s.default)(this,"uploadFile",((e,a,t)=>{const s=new AbortController,n=s.signal,{file:l,status:r,error:o}=e.getValue();if(o&&"idle"===r)return i.of(void 0);if(!["idle","upload_failed"].includes(r))return i.of(void 0);let d;e.setState({status:"uploading",error:void 0});const{name:c}={name:((u=l.name).substring(0,u.lastIndexOf("."))||u).trim().slice(0,256)};var u;const p=l.type||void 0,f=t;return i.from(function(e){var a;return Boolean(null===(a=e.type)||void 0===a?void 0:a.startsWith("image/"))}(l)?this.loadImageMetadata(l):i.of(void 0)).pipe(i.mergeMap((e=>this.client.create({kind:this.fileKind.id,name:c,mimeType:p,meta:e?{...e,...f}:f}))),i.mergeMap((e=>(d=e.file,i.race(a.pipe(i.map((()=>{throw s.abort(),new Error("Abort!")}))),this.client.upload({body:l,id:d.id,kind:this.fileKind.id,abortSignal:n,selfDestructOnAbort:!0,contentType:p}))))),i.map((()=>{var a;e.setState({status:"uploaded",id:null===(a=d)||void 0===a?void 0:a.id,fileJSON:d})})),i.catchError((a=>{const t="Abort!"===a.message;return e.setState({status:"upload_failed",error:t?void 0:a}),i.of(t?void 0:a)})))})),(0,s.default)(this,"upload",(e=>{if(this.isUploading())throw new Error("Upload already in progress");const a=new i.ReplaySubject(1),t=this.abort$.subscribe(a),s=this.files$$.pipe(i.take(1),i.switchMap((t=>i.forkJoin(t.map((t=>this.uploadFile(t,a,e)))))),i.map((()=>{})),i.finalize((()=>{this.opts.allowRepeatedUploads&&this.clear(),t.unsubscribe()})),i.shareReplay());return s.subscribe(),s})),(0,s.default)(this,"dispose",(()=>{for(const e of this.subscriptions)e.unsubscribe()})),this.fileKind=e,this.client=a,this.opts=t,this.loadImageMetadata=n;const l=this.files$$.pipe(i.switchMap((e=>i.combineLatest(e))));this.subscriptions=[l.pipe(i.map((e=>e.some((e=>"uploading"===e.status)))),i.distinctUntilChanged()).subscribe(this.uploading$),l.pipe(i.map((e=>{const a=e.find((e=>Boolean(e.error)));return a?a.error:void 0})),i.filter(Boolean)).subscribe(this.error$),l.pipe(i.filter((e=>Boolean(e.length)&&e.every((e=>"uploaded"===e.status)))),i.map((e=>e.map((e=>({id:e.id,kind:this.fileKind.id,fileJSON:e.fileJSON})))))).subscribe(this.done$)]}isUploading(){return this.uploading$.getValue()}hasFiles(){return this.files$$.getValue().length>0}}const h=({fileKind:e,client:a,imageMetadataFactory:t,...s})=>new UploadState(e,a,s,t)},4387:(e,a,t)=>{t.d(a,{M:()=>l});var s=t(6735),i=t(3867),n=t(7808);const l=(e=n.Y3)=>{const{capabilities:a}=(0,i.o1)().services.application;return Object.entries(a).reduce(((a,[t,s])=>{if(!t.endsWith("CasesV3"))return a;for(const t of e){const e=`cases_${t}`;if(!s[`${t}_cases`]&&!s[e])return a}return a.push(r(t)),a}),[])},r=e=>e===s.hL?s.sZ:e.replace("CasesV3","")},1190:(e,a,t)=>{t.d(a,{$O:()=>M,Co:()=>i.Co,DP:()=>K,Ez:()=>n.Ez,FH:()=>i.FH,Fs:()=>c,G:()=>C,HT:()=>X,HV:()=>i.HV,Hk:()=>i.Hk,IJ:()=>x,I_:()=>n.I_,JL:()=>b,Kd:()=>i.Kd,Km:()=>O,LO:()=>w,O0:()=>h,Rj:()=>G,S6:()=>Z,TO:()=>i.TO,TT:()=>i.TT,V7:()=>q,W0:()=>i.W0,X4:()=>ee,XJ:()=>i.XJ,XQ:()=>S,Y4:()=>m,YK:()=>L,Z8:()=>N,ZC:()=>B,_e:()=>_,bO:()=>i.bO,cn:()=>F,d$:()=>I,d1:()=>D,eZ:()=>W,ez:()=>i.ez,gi:()=>g,gp:()=>i.gp,gy:()=>u,hZ:()=>V,i4:()=>y,iK:()=>R,ie:()=>H,jA:()=>k,jF:()=>i.jF,jh:()=>T,kw:()=>d,l5:()=>n.l5,m2:()=>j,mi:()=>Q,nD:()=>Y,nf:()=>ae,o2:()=>n.o2,o5:()=>v,oW:()=>$,pz:()=>A,qL:()=>l,r9:()=>U,rU:()=>p,s1:()=>r,sP:()=>z,t:()=>P,tC:()=>i.tC,tU:()=>i.tU,uJ:()=>i.uJ,uU:()=>i.uU,vH:()=>o,vM:()=>i.vM,wJ:()=>J,wp:()=>f,x9:()=>i.x9,yD:()=>n.yD,zJ:()=>E});var s=t(5008),i=t(8228),n=t(2432);const l=s.i18n.translate("xpack.cases.caseView.actionLabel.addedField",{defaultMessage:"added"}),r=s.i18n.translate("xpack.cases.caseView.actionLabel.changededField",{defaultMessage:"changed"}),o=s.i18n.translate("xpack.cases.caseView.actionLabel.enabledSetting",{defaultMessage:"enabled"}),d=s.i18n.translate("xpack.cases.caseView.actionLabel.disableSetting",{defaultMessage:"disabled"}),c=e=>s.i18n.translate("xpack.cases.caseView.actionLabel.selectedThirdParty",{values:{thirdParty:e},defaultMessage:"selected { thirdParty } as incident management system"}),u=s.i18n.translate("xpack.cases.caseView.actionLabel.removedThirdParty",{defaultMessage:"removed external incident management system"}),p=s.i18n.translate("xpack.cases.caseView.actionLabel.editedField",{defaultMessage:"edited"}),f=s.i18n.translate("xpack.cases.caseView.actionLabel.removedField",{defaultMessage:"removed"}),g=e=>s.i18n.translate("xpack.cases.caseView.actionLabel.changeFieldToEmpty",{values:{field:e},defaultMessage:'changed {field} to "None"'}),m=e=>s.i18n.translate("xpack.cases.caseView.actionLabel.viewIncident",{defaultMessage:"View {incidentNumber}",values:{incidentNumber:e}}),h=s.i18n.translate("xpack.cases.caseView.actionLabel.pushedNewIncident",{defaultMessage:"pushed as new incident"}),b=s.i18n.translate("xpack.cases.caseView.actionLabel.updateIncident",{defaultMessage:"updated incident"}),v=(s.i18n.translate("xpack.cases.caseView.actionLabel.addDescription",{defaultMessage:"added description"}),s.i18n.translate("xpack.cases.caseView.edit.description",{defaultMessage:"Edit description"})),w=s.i18n.translate("xpack.cases.caseView.description.collapse",{defaultMessage:"Collapse description"}),x=s.i18n.translate("xpack.cases.caseView.description.expand",{defaultMessage:"Expand description"}),k=s.i18n.translate("xpack.cases.caseView.edit.quote",{defaultMessage:"Quote"}),M=s.i18n.translate("xpack.cases.caseView.edit.comment",{defaultMessage:"Edit comment"}),y=s.i18n.translate("xpack.cases.caseView.delete.comment",{defaultMessage:"Delete comment"}),E=s.i18n.translate("xpack.cases.caseView.deleteTitle.comment",{defaultMessage:"Delete this comment?"}),S=(s.i18n.translate("xpack.cases.caseView.actionLabel.on",{defaultMessage:"on"}),s.i18n.translate("xpack.cases.caseView.statusLabel",{defaultMessage:"Status"})),P=s.i18n.translate("xpack.cases.caseView.case",{defaultMessage:"case"}),L=s.i18n.translate("xpack.cases.caseView.comment",{defaultMessage:"comment"}),T=s.i18n.translate("xpack.cases.caseView.caseRefresh",{defaultMessage:"Refresh case"}),I=(s.i18n.translate("xpack.cases.caseView.activity",{defaultMessage:"Activity"}),s.i18n.translate("xpack.cases.caseView.caseSettings",{defaultMessage:"Case settings"})),R=e=>s.i18n.translate("xpack.cases.caseView.emailSubject",{values:{caseTitle:e},defaultMessage:"Security Case - {caseTitle}"}),O=e=>s.i18n.translate("xpack.cases.caseView.emailBody",{values:{caseUrl:e},defaultMessage:"Case reference: {caseUrl}"}),j=(s.i18n.translate("xpack.cases.caseView.fieldChanged",{defaultMessage:"changed connector field"}),s.i18n.translate("xpack.cases.caseView.syncAlertsLabel",{defaultMessage:"Sync alerts"})),C=s.i18n.translate("xpack.cases.caseView.syncAlertsLowercaseLabel",{defaultMessage:"sync alerts"}),U=s.i18n.translate("xpack.cases.caseView.extractObservablesLowercaseLabel",{defaultMessage:"extract observables"}),V=s.i18n.translate("xpack.cases.caseView.doesNotExist.title",{defaultMessage:"This case does not exist"}),A=e=>s.i18n.translate("xpack.cases.caseView.doesNotExist.description",{values:{caseId:e},defaultMessage:"A case with id {caseId} could not be found. This likely means the case has been deleted, or the id is incorrect."}),D=s.i18n.translate("xpack.cases.caseView.doesNotExist.button",{defaultMessage:"Back to Cases"}),F=s.i18n.translate("xpack.cases.caseView.tabs.activity",{defaultMessage:"Activity"}),N=s.i18n.translate("xpack.cases.caseView.tabs.attachments",{defaultMessage:"Attachments"}),$=s.i18n.translate("xpack.cases.caseView.tabs.alerts",{defaultMessage:"Alerts"}),z=s.i18n.translate("xpack.cases.caseView.tabs.events",{defaultMessage:"Events"}),_=s.i18n.translate("xpack.cases.caseView.tabs.files",{defaultMessage:"Files"}),B=s.i18n.translate("xpack.cases.caseView.tabs.observables",{defaultMessage:"Observables"}),H=s.i18n.translate("xpack.cases.caseView.tabs.similar",{defaultMessage:"Similar cases"}),K=s.i18n.translate("xpack.cases.caseView.tabs.alerts.emptyDescription",{defaultMessage:"No alerts have been added to this case."}),J=e=>s.i18n.translate("xpack.cases.caseView.sendEmalLinkAria",{values:{user:e},defaultMessage:"click to send an email to {user}"}),G=s.i18n.translate("xpack.cases.caseView.editAssigneesAriaLabel",{defaultMessage:"click to edit assignees"}),X=s.i18n.translate("xpack.cases.caseView.noAssignees",{defaultMessage:"No users are assigned"}),W=s.i18n.translate("xpack.cases.caseView.assignUser",{defaultMessage:"Assign a user"}),Y=s.i18n.translate("xpack.cases.caseView.spacedOrText",{defaultMessage:" or "}),Z=s.i18n.translate("xpack.cases.caseView.assignYourself",{defaultMessage:"assign yourself"}),q=e=>s.i18n.translate("xpack.cases.caseView.totalUsersAssigned",{defaultMessage:"{total} assigned",values:{total:e}}),Q=e=>s.i18n.translate("xpack.cases.caseView.observables.addedObservables",{values:{totalObservables:e},defaultMessage:"added {totalObservables, plural, =1 {an} other {{totalObservables}}} {totalObservables, plural, =1 {observable} other {observables}}"}),ee=e=>s.i18n.translate("xpack.cases.caseView.observables.deletedObservables",{values:{totalObservables:e},defaultMessage:"deleted {totalObservables, plural, =1 {an} other {{totalObservables}}} {totalObservables, plural, =1 {observable} other {observables}}"}),ae=e=>s.i18n.translate("xpack.cases.caseView.observables.updatedObservables",{values:{totalObservables:e},defaultMessage:"updated {totalObservables, plural, =1 {an} other {{totalObservables}}} {totalObservables, plural, =1 {observable} other {observables}}"})},679:(e,a,t)=>{t.d(a,{uY:()=>he,X2:()=>oe,To:()=>U,HX:()=>ue});var s=t(3185),i=t(4286),n=t.n(i),l=t(1060),r=t(1319),o=t(6791);const d=({disableLinks:e,href:a,target:t,children:s,...i})=>(0,o.jsx)(r.EuiToolTip,{content:a},(0,o.jsx)(r.EuiLink,{href:e?void 0:a,"data-test-subj":"markdown-link",rel:"nofollow",target:"_blank"},s));d.displayName="MarkdownLink";const c=(0,i.memo)(d);var u=t(1624),p=t(3867),f=t(190),g=t(5008),m=t(5879),h=t(1493),b=t(6260),v=t(2712);const w=n().createContext(null);var x=t(9335),k=t(9501),M=t(6735),y=t(6467),E=t(1642);const S={from:"now-7d",to:"now",mode:"relative"};var P={name:"18axvdo",styles:"display:inline-flex;.euiToolTipAnchor{display:inline-flex;}"};const L=({node:e,onCancel:a,onSave:t})=>{const s=(0,h.useLocation)(),{application:{currentAppId$:n},embeddable:l,lens:d,storage:c,contentManagement:u,uiSettings:k,data:{query:{timefilter:{timefilter:L}}}}=(0,p.o1)().services,[T,I]=(0,i.useState)(void 0),{draftComment:R,clearDraftComment:O}=(0,x.O)(),j=(0,i.useContext)(w),C=(0,i.useContext)(r.EuiMarkdownContext),U=(()=>{const{appId:e}=(0,y.Y)();return e===M.Vw})(),{euiTheme:V}=(0,r.useEuiTheme)(),A=(0,i.useCallback)((()=>{T&&(null==l||l.getStateTransfer().getIncomingEmbeddablePackage(T,!0),O()),a()}),[O,T,l,a]),D=(0,i.useCallback)(((e,a)=>{t(`!{${v.ID}${JSON.stringify({timeRange:(0,E.O)(a),attributes:e})}}`,{block:!0}),A()}),[A,t]),F=(0,i.useCallback)(((e,a,t)=>{C.replaceNode(t,`!{${v.ID}${JSON.stringify({timeRange:(0,E.O)(a),attributes:e})}}`),A()}),[A,C]),N=(0,i.useMemo)((()=>U?`/insightsAndAlerting/cases${s.pathname}${s.search}`:`${s.pathname}${s.search}`),[U,s.pathname,s.search]),$=(0,i.useCallback)((()=>{c.set(v.CW,{commentId:null==j?void 0:j.editorId,comment:null==j?void 0:j.value,position:null==e?void 0:e.position,caseTitle:null==j?void 0:j.caseTitle,caseTags:null==j?void 0:j.caseTags}),null==d||d.navigateToPrefilledEditor(void 0,{originatingApp:T,originatingPath:N})}),[c,null==j?void 0:j.editorId,null==j?void 0:j.value,null==j?void 0:j.caseTitle,null==j?void 0:j.caseTags,null==e?void 0:e.position,d,T,N]),z=(0,i.useCallback)(((a,t=S)=>{c.set(v.CW,{commentId:null==j?void 0:j.editorId,comment:null==j?void 0:j.value,position:null==e?void 0:e.position,caseTitle:null==j?void 0:j.caseTitle,caseTags:null==j?void 0:j.caseTags}),null==d||d.navigateToPrefilledEditor(a||null!=e&&e.attributes?{id:"",timeRange:t,attributes:a||(null==e?void 0:e.attributes)}:void 0,{originatingApp:T,originatingPath:N})}),[c,null==j?void 0:j.editorId,null==j?void 0:j.value,null==j?void 0:j.caseTitle,null==j?void 0:j.caseTags,null==e?void 0:e.position,null==e?void 0:e.attributes,d,T,N]),_=(0,i.useCallback)(((e,a,t,s)=>{z({...s.attributes,title:"",references:s.references})}),[z]),B=(0,i.useMemo)((()=>[{type:"lens",getIconForSavedObject:()=>"lensApp",name:g.i18n.translate("xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.savedObjectType.lens",{defaultMessage:"Lens"}),includeFields:["*"]}]),[]);(0,i.useEffect)((()=>{null!=e&&e.attributes&&T&&z(e.attributes,e.timeRange)}),[z,e,T]),(0,i.useEffect)((()=>{(async()=>{const e=await n.pipe((0,f.first)()).toPromise();I(e)})()}),[n]),(0,i.useEffect)((()=>{var e,a,t;let s;T&&(s=null==l?void 0:l.getStateTransfer().getIncomingEmbeddablePackage(T,!0));const i=null===(e=s)||void 0===e?void 0:e.find((e=>"lens"===e.type));if(i&&null!=i&&null!==(a=i.serializedState)&&void 0!==a&&null!==(t=a.rawState)&&void 0!==t&&t.attributes){const e=L.getTime(),a=null!=e&&e.from&&null!=e&&e.to?{from:e.from,to:e.to,mode:[e.from,e.to].join("").includes("now")?"relative":"absolute"}:void 0;if(null!=R&&R.position)return void F(i.serializedState.rawState.attributes,a,R.position);R&&D(i.serializedState.rawState.attributes,a)}}),[l,c,L,T,D,F,R]);const H=(0,o.jsx)(r.EuiButton,{onClick:$,iconType:"plusInCircle"},(0,o.jsx)(m.FormattedMessage,{id:"xpack.cases.markdownEditor.plugins.lens.createVisualizationButtonLabel",defaultMessage:"Create new"}));return(0,o.jsx)(r.EuiFlexGroup,{css:(0,o.css)("width:",V.breakpoint.m,";height:100%;.euiModalBody{min-height:300px;}",""),direction:"column",gutterSize:"none"},(0,o.jsx)(r.EuiModalHeader,null,(0,o.jsx)(r.EuiFlexGroup,{gutterSize:"s",alignItems:"center"},(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)(r.EuiModalHeaderTitle,null,(0,o.jsx)(m.FormattedMessage,{id:"xpack.cases.markdownEditor.plugins.lens.addVisualizationModalTitle",defaultMessage:"Add visualization"}))),(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)("span",{css:P},(0,o.jsx)(r.EuiBetaBadge,{label:g.i18n.translate("xpack.cases.markdownEditor.plugins.lens.betaLabel",{defaultMessage:"Beta"}),tooltipContent:g.i18n.translate("xpack.cases.markdownEditor.plugins.lens.betaDescription",{defaultMessage:"This module is not GA. You can only insert one lens per comment for now. Please help us by reporting bugs."})}))))),(0,o.jsx)(r.EuiModalBody,null,(0,o.jsx)(b.SavedObjectFinder,{key:"searchSavedObjectFinder",id:"casesMarkdownLens",onChoose:_,showFilter:!1,noItemsMessage:(0,o.jsx)(m.FormattedMessage,{id:"xpack.cases.markdownEditor.plugins.lens.insertLensSavedObjectModal.searchSelection.notFoundLabel",defaultMessage:"No matching lens found."}),savedObjectMetaData:B,fixedPageSize:10,services:{contentClient:u.client,uiSettings:k},leftChildren:H,helpText:g.i18n.translate("xpack.cases.markdownEditor.plugins.lens.savedObjects.finder.searchInputHelpText",{defaultMessage:"Insert an existing lens visualization or create a new one. Any changes or new visualizations will only apply to this comment."})})),(0,o.jsx)(r.EuiModalFooter,null,(0,o.jsx)(r.EuiButton,{onClick:A,fill:!0},(0,o.jsx)(m.FormattedMessage,{id:"xpack.cases.markdownEditor.plugins.lens.closeButtonLabel",defaultMessage:"Close"}))))};L.displayName="LensEditor";const T=n().memo(L),I={name:v.ID,button:{label:k.D,iconType:"lensApp"},helpText:(0,o.jsx)(r.EuiCodeBlock,{language:"md",paddingSize:"s",fontSize:"l"},"!{lens<config>}"),editor:T},R=function(){const e=this.Parser,a=e.prototype.blockTokenizers,t=e.prototype.blockMethods;a.lens=function(e,a,t){if(!1===a.startsWith(v.H3))return!1;const s=a[6];if("{"!==s&&"}"!==s)return!1;if(t)return!0;const i="{"===s;let n=v.H3,l={};if(i){let t="",s=0;for(let e=6;e<a.length;e++){const i=a[e];if("{"===i)s++,t+=i;else if("}"===i){if(s--,-1===s)break;t+=i}else t+=i}n+=t;try{l=JSON.parse(t)}catch(a){const t=e.now();this.file.fail(`Unable to parse lens JSON configuration: ${a}`,{line:t.line,column:t.column+6})}}return n+="}",e(n)({type:v.ID,...l})},t.splice(t.indexOf("text"),0,v.ID)};var O=t(509);const j=e=>{var a,t;const s=p.P7.getConfig(),n=null===(a=(0,u._)())||void 0===a?void 0:a.editor_plugins,l=(0,p.Ix)();return(0,i.useMemo)((()=>{var a;const t=(0,r.getDefaultEuiMarkdownUiPlugins)(),i=(0,r.getDefaultEuiMarkdownParsingPlugins)(),o=(0,r.getDefaultEuiMarkdownProcessingPlugins)();return n&&(t.push(n.uiPlugin),i.push(n.parsingPlugin),o[1][1].components.timeline=n.processingPluginRenderer),null==s||null===(a=s.markdownPlugins)||void 0===a||!a.lens||null!=e&&e.includes(v.ID)||null==l||!l.visualize.crud||t.push(I),i.push(R),o[1][1].components.lens=O.M,{uiPlugins:t,parsingPlugins:i,processingPlugins:o}}),[null==l?void 0:l.visualize.crud,e,null==s||null===(t=s.markdownPlugins)||void 0===t?void 0:t.lens,n])},C=({children:e,disableLinks:a,textSize:t})=>{const{processingPlugins:n,parsingPlugins:d}=j(),u=(0,l.cloneDeep)(n);return u[1][1].components.a=(0,i.useMemo)((()=>(e=>{const a=(0,i.memo)((a=>(0,o.jsx)(c,(0,s.default)({},a,{disableLinks:e}))));return a.displayName="MarkdownLinkProcessingComponent",a})(a)),[a]),(0,o.jsx)(r.EuiMarkdownFormat,{parsingPluginList:d,processingPluginList:u,grow:!0,textSize:t},e)};C.displayName="MarkdownRenderer";const U=(0,i.memo)(C);var V=t(770),A=t(7583),D=t.n(A);const F="euiButtonIcon-isDisabled";var N=t(7402);const $=(0,i.forwardRef)((({ariaLabel:e,"data-test-subj":a,editorId:t,height:n,onChange:l,value:d,disabledUiPlugins:c,errors:u,...p},f)=>{const g=(0,i.useRef)(void 0),[m,h]=(0,i.useState)([]),b=(0,i.useCallback)(((e,{messages:a,ast:t})=>{h(e?[e]:a),g.current=t}),[]),{parsingPlugins:w,processingPlugins:x,uiPlugins:M}=j(c),y=(0,i.useRef)(null);return(({astRef:e,editorRef:a,uiPlugins:t,value:s})=>{const n=(0,i.useRef)(!1),[l,r]=(0,i.useState)(!1),o=(0,i.useCallback)((()=>{var e,t;if(null!=a&&null!==(e=a.current)&&void 0!==e&&e.textarea&&null!==(t=a.current)&&void 0!==t&&t.toolbar){var s,i;const e=null===(s=a.current)||void 0===s||null===(i=s.toolbar)||void 0===i?void 0:i.querySelector(`[aria-label="${k.D}"]`);if(e){const a=e.className.includes(F),t=e.getAttribute("style");a&&t&&(e.className=e.className.replace(F,""),e.setAttribute("style",t.replace("pointer-events: none;","")))}}}),[a]),d=(0,i.useCallback)((()=>{var e;if(null!=a&&null!==(e=a.current)&&void 0!==e&&e.textarea&&a.current.toolbar){var t;const e=null===(t=a.current.toolbar)||void 0===t?void 0:t.querySelector(`[aria-label="${k.D}"]`);e&&(e.className.includes(F)||(e.className+=` ${F}`,e.setAttribute("style","pointer-events: none;")))}}),[a]);(0,i.useEffect)((()=>{n.current=(0,V.some)(t,["name","lens"])}),[t]),D()((()=>{l||null==s||!s.includes(v.H3)?o():d()}),100,[s,l]),(0,i.useEffect)((()=>{var t,s;if(null==(null==a||null===(t=a.current)||void 0===t?void 0:t.textarea)||null==(null==e?void 0:e.current)||!n.current)return;const i=()=>{var t;const{selectionStart:s}=null===(t=a.current)||void 0===t?void 0:t.textarea;let i=e.current;e:for(;;){if(i.children)for(let e=0;e<i.children.length;e++){const a=i.children[e];if(a.position&&a.position.start.offset<s&&s<a.position.end.offset){if("text"===a.type)break e;i=a;continue e}}break}r("lens"===i.type)},l=null===(s=a.current)||void 0===s?void 0:s.textarea;return l.addEventListener("keyup",i),l.addEventListener("mouseup",i),()=>{l.removeEventListener("keyup",i),l.removeEventListener("mouseup",i)}}),[e,a])})({astRef:g,uiPlugins:M,editorRef:f,value:d}),(0,i.useImperativeHandle)(f,(()=>{var e,a;if(!y.current)return null;const t=null===(e=y.current)||void 0===e||null===(a=e.textarea)||void 0===a?void 0:a.closest(".euiMarkdownEditor");return{...y.current,toolbar:null==t?void 0:t.querySelector(".euiMarkdownEditorToolbar")}})),(0,o.jsx)(r.EuiMarkdownEditor,(0,s.default)({css:N.mm,ref:y,"aria-label":e,editorId:t,onChange:l,value:d,uiPlugins:M,parsingPluginList:w,processingPluginList:x,onParse:b,errors:[...m,...null!=u?u:[]],"data-test-subj":a,height:n},p))}));$.displayName="MarkdownEditor";const z=(0,i.memo)($);var _=t(2602),B=t(8228),H=t(4897),K=t.n(H),J=t(9673),G=t(2194),X=t(6177);g.i18n.translate("xpack.cases.markdownEditor.preview",{defaultMessage:"Preview"});const W=g.i18n.translate("xpack.cases.markdownEditor.noSimultaneousUploads.message",{defaultMessage:"Simultaneous file uploads are not supported."}),Y=g.i18n.translate("xpack.cases.markdownEditor.unsupportedMimeType.message",{defaultMessage:"Only PNG and JPG images are supported."}),Z=["image/png","image/jpeg"];let q=function(e){return e.IDLE="idle",e.START_UPLOAD="start_upload",e.UPLOADING="uploading",e.FINISHED="finished",e.ERROR="error",e}({}),Q=function(e){return e.RESET="RESET",e.START_UPLOAD="START_UPLOAD",e.UPLOAD_IN_PROGRESS="UPLOAD_IN_PROGRESS",e.UPLOAD_FINISHED="UPLOAD_FINISHED",e.UPLOAD_ERROR="UPLOAD_ERROR",e}({});const ee=(e,a)=>{switch(a.type){case Q.RESET:return{phase:q.IDLE};case Q.START_UPLOAD:return{phase:q.START_UPLOAD,filename:a.filename,placeholder:a.placeholder};case Q.UPLOAD_IN_PROGRESS:return{phase:q.UPLOADING,filename:a.filename,placeholder:a.placeholder};case Q.UPLOAD_FINISHED:return{phase:q.FINISHED,file:a.file,placeholder:a.placeholder};case Q.UPLOAD_ERROR:return{phase:q.ERROR,errors:a.errors};default:return e}};const ae={phase:q.IDLE};function te({editorRef:e,field:a,caseId:t,owner:s,fileKindId:n}){const{client:l}=(0,J.A)(),r=l.getFileKind(n),o=(0,i.useMemo)((()=>(0,X.L)({client:l,fileKind:r,allowRepeatedUploads:!1})),[l,r]),[d,c]=(0,i.useReducer)(ee,ae),u=function(e){return e&&"function"!=typeof e&&e.current?e.current.textarea:null}(e);!function(e,a,t){(0,i.useEffect)((()=>{const s=[e.files$.subscribe((e=>{((e,a)=>e.length&&"uploaded"!==e[0].status&&a.phase===q.IDLE)(e,a)&&t({type:Q.START_UPLOAD,filename:e[0].file.name,placeholder:`\x3c!-- uploading "${e[0].file.name}" --\x3e`})})),e.done$.subscribe((e=>{null!=e&&e.length&&a.phase===q.UPLOADING?t({type:Q.UPLOAD_FINISHED,file:e[0],placeholder:a.placeholder}):t({type:Q.RESET})})),e.error$.subscribe((e=>e&&t({type:Q.UPLOAD_ERROR,errors:[e]})))];return()=>s.forEach((e=>e.unsubscribe()))}),[e,a,t])}(o,d,c);const p=(0,i.useCallback)(((e,t)=>{if(!u)return;const i=u.value.replace(t,(n=e.fileJSON.name,r=l.getDownloadHref({id:e.id,fileKind:(0,G.Ng)(s)}),`![${n}${(o=e.fileJSON.extension)?`.${o}`:""}](${r})`));var n,r,o;a.setValue(i)}),[u,s,l,a]),f=(0,i.useRef)();return function(e,a,t,s){(0,i.useEffect)((()=>{const{phase:i}=e;if(i!==q.START_UPLOAD||!t)return;const{filename:n,placeholder:l}=e,{selectionStart:r,selectionEnd:o}=t,d=s.value.slice(0,r),c=s.value.slice(o);s.setValue(d+l+c),a({type:Q.UPLOAD_IN_PROGRESS,filename:n,placeholder:l})}),[e,t,s,a])}(d,c,u,a),function(e,a,t){(0,i.useEffect)((()=>{const{phase:s}=e;if(s!==q.FINISHED)return;const{file:i,placeholder:n}=e;a(i,n),t({type:Q.RESET})}),[e,a,t])}(d,p,c),(0,i.useLayoutEffect)((()=>{f.current=e=>{var a;const i=null===(a=e.clipboardData)||void 0===a?void 0:a.items;if(!i)return;const n=Array.from(i).map((e=>null==e?void 0:e.getAsFile())).filter((e=>!!e));if(n.length>1)return c({type:Q.UPLOAD_ERROR,errors:[W]}),void e.preventDefault();if(0===n.length||!n[0])return void(d.phase===q.ERROR&&c({type:Q.RESET}));const l=n[0];if(!Z.includes(l.type))return c({type:Q.UPLOAD_ERROR,errors:[Y]}),void e.preventDefault();e.preventDefault();try{o.isUploading()||o.setFiles([l])}catch(e){c({type:Q.UPLOAD_ERROR,errors:[e]})}(function(e,a){return e.hasFiles()&&!e.isUploading()&&a})(o,t)&&(c({type:Q.RESET}),o.upload({caseIds:[t],owner:s}))}}),[t,s,d.phase,o]),(0,i.useLayoutEffect)((()=>{if(!u)return;const e=e=>{var a;return null===(a=f.current)||void 0===a?void 0:a.call(f,e)};return u.addEventListener("paste",e),()=>{u.removeEventListener("paste",e)}}),[u]),{isUploading:d.phase===q.UPLOADING,uploadState:o,errors:d.phase===q.ERROR?d.errors:void 0}}const se=(0,i.forwardRef)(((e,a)=>{const{ariaLabel:t,field:s,caseId:i,editorId:l,disabledUiPlugins:d,"data-test-subj":c,owner:u}=e,p=(0,G.Ng)(u),{isUploading:f,errors:g}=te({editorRef:a,field:s,caseId:i,owner:u,fileKindId:p});return(0,o.jsx)(n().Fragment,null,(0,o.jsx)(r.EuiProgress,{css:(0,o.css)({visibility:f?"visible":"hidden"},"",""),size:"m"}),(0,o.jsx)(z,{ref:a,ariaLabel:t,editorId:l,onChange:s.setValue,value:s.value,disabledUiPlugins:d,"data-test-subj":`${c}-markdown-editor`,errors:g}))}));se.displayName="PastableMarkdownEditor";const ie=n().memo(se);var ne=t(6090),le=t(4124);const re=(0,i.forwardRef)(((e,a)=>{const t=function(){try{return!!(0,J.A)()}catch{return!1}}(),{owner:i}=(0,le.g)(),n=i[0];return t&&e.caseId&&(0,ne.u)(n)?(0,o.jsx)(ie,(0,s.default)({},e,{ref:a,field:e.field,caseId:e.caseId,owner:n})):(0,o.jsx)(z,(0,s.default)({},e,{ref:a,onChange:e.onChange,value:e.value}))}));re.displayName="CommentEditor";const oe=n().memo((0,i.forwardRef)((({id:e,field:a,dataTestSubj:t,idAria:s,bottomRightContent:n,caseTitle:l,caseTags:d,caseId:c,draftStorageKey:u,disabledUiPlugins:p,initialValue:f},g)=>{const{isInvalid:m,errorMessage:h}=(0,_.getFieldValidityAndErrorMessage)(a),{hasConflicts:b}=(({field:e,sessionKey:a,initialValue:t})=>{const[s,n]=(0,i.useState)(!1),l=(0,i.useRef)(!0),r=(0,i.useRef)(t),[o,d]=K()(a,"",!0);return(0,V.isEmpty)(o)||(0,V.isEmpty)(a)||!l.current||e.setValue(o),l.current&&(l.current=!1),t!==r.current&&t!==e.value&&(r.current=t,n(!0)),D()((()=>{(0,V.isEmpty)(a)||d(e.value)}),500,[e.value]),{hasConflicts:s}})({field:a,sessionKey:null!=u?u:"",initialValue:f}),{euiTheme:v}=(0,r.useEuiTheme)(),x=B.dC("description"===e?e:"comment"),k=(0,i.useMemo)((()=>({editorId:e,value:a.value,caseTitle:l,caseTags:d})),[e,a.value,l,d]);return(0,o.jsx)(w.Provider,{value:k},(0,o.jsx)(r.EuiFormRow,{"data-test-subj":t,describedByIds:s?[s]:void 0,fullWidth:!0,error:h,helpText:a.helpText,isInvalid:m,label:a.label,labelAppend:a.labelAppend},(0,o.jsx)(re,{ariaLabel:s,"data-test-subj":`${t}-markdown-editor`,editorId:e,disabledUiPlugins:p,field:a,caseId:c,ref:g,onChange:a.setValue,value:a.value})),n&&(0,o.jsx)(r.EuiFlexGroup,{css:(0,o.css)("padding:",v.size.m," 0;",""),justifyContent:"flexEnd"},(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)(r.EuiText,{color:"danger",size:"s"},b&&x),(0,o.jsx)(r.EuiSpacer,{size:"s"}),n)))})));oe.displayName="MarkdownEditorForm";const de=e=>(0,o.css)("padding:",`${e.size.m} ${e.size.l}`,";text-overflow:ellipsis;display:-webkit-box;-webkit-box-orient:vertical;",""),ce=({content:e})=>{const{euiTheme:a}=(0,r.useEuiTheme)();return(0,o.jsx)("div",{className:"eui-xScroll",css:de(a),"data-test-subj":"scrollable-markdown"},(0,o.jsx)(U,null,e))};ce.displayName="ScrollableMarkdownRenderer";const ue=n().memo(ce);var pe=t(1190);const fe=({handleSaveAction:e,handleCancelAction:a,isSaveDisabled:t})=>(0,o.jsx)(r.EuiFlexGroup,{gutterSize:"s",justifyContent:"flexEnd",responsive:!1},(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)(r.EuiButtonEmpty,{"data-test-subj":"editable-cancel-markdown",size:"s",onClick:a,iconType:"cross"},pe.bO)),(0,o.jsx)(r.EuiFlexItem,{grow:!1},(0,o.jsx)(r.EuiButton,{"data-test-subj":"editable-save-markdown",color:"primary",fill:!0,iconType:"save",onClick:e,disabled:t,size:"s"},pe.W0)));fe.displayName="EditableMarkdownFooterComponent";const ge=n().memo(fe),me=(0,i.forwardRef)((({id:e,content:a,caseId:t,fieldName:s,onChangeEditable:n,onSaveContent:l,editorRef:r,formSchema:d},c)=>{const{owner:u}=(0,le.g)(),p=(0,ne.Z)({appId:u[0],caseId:t,commentId:e}),f={content:a},{form:g}=(0,_.useForm)({defaultValue:f,options:{stripEmptyFields:!1},schema:d}),{submit:m,setFieldValue:h,isValid:b}=g,v=(0,i.useCallback)((e=>{h(s,e)}),[h,s]);(0,i.useImperativeHandle)(c,(()=>({setComment:v,editor:r.current})));const w=(0,i.useCallback)((()=>{n(e),(0,N.n_)(p)}),[e,n,p]),x=(0,i.useCallback)((async()=>{const{isValid:t,data:s}=await m();t&&s.content!==a&&l(s.content),n(e),(0,N.n_)(p)}),[a,e,n,l,m,p]);return(0,o.jsx)(_.Form,{form:g,"data-test-subj":"editable-markdown-form"},(0,o.jsx)(_.UseField,{path:s,component:oe,componentProps:{ref:r,"aria-label":"Cases markdown editor",value:a,id:e,caseId:t,draftStorageKey:p,bottomRightContent:(0,o.jsx)(ge,{handleSaveAction:x,handleCancelAction:w,isSaveDisabled:void 0!==b&&!b}),initialValue:a}}))}));me.displayName="EditableMarkDownRenderer";const he=n().memo(me)},9501:(e,a,t)=>{t.d(a,{D:()=>s});const s=t(5008).i18n.translate("xpack.cases.markdownEditor.plugins.lens.visualizationButtonLabel",{defaultMessage:"Visualization"})},9335:(e,a,t)=>{t.d(a,{O:()=>o});var s=t(4286),i=t(190),n=t(3867),l=t(2712),r=t(9501);const o=()=>{const{application:{currentAppId$:e},embeddable:a,storage:t}=(0,n.o1)().services,[o,d]=(0,s.useState)(null),[c,u]=(0,s.useState)(!1);return(0,s.useEffect)((()=>{(async()=>{const s=await e.pipe((0,i.first)()).toPromise();if(!s)return;const n=null==a?void 0:a.getStateTransfer().getIncomingEmbeddablePackage(s),r=t.get(l.CW);u(!!n),r&&d(r)})()}),[e,a,t]),{draftComment:o,hasIncomingLensState:c,openLensModal:(0,s.useCallback)((({editorRef:e})=>{if(e&&e.textarea&&e.toolbar){var a;const t=null===(a=e.toolbar)||void 0===a?void 0:a.querySelector(`[aria-label="${r.D}"]`);t&&t.click()}}),[]),clearDraftComment:(0,s.useCallback)((()=>{t.remove(l.CW),d(null)}),[t])}}},6090:(e,a,t)=>{t.d(a,{Z:()=>i,u:()=>l});var s=t(6735);const i=({caseId:e,commentId:a,appId:t})=>`cases.${t&&""!==t?t:"cases"}.${""!==e?e:"case"}.${""!==a?a:"comment"}.markdownEditor`,n=new Set(s.H1),l=e=>n.has(e)},2253:(e,a,t)=>{t.d(a,{E:()=>l,s:()=>r});var s=t(4286),i=t.n(s),n=t(6791);const l=i().createContext(null),r=({children:e,timelineIntegration:a})=>{const[t]=(0,s.useState)(null!=a?a:null);return(0,n.jsx)(l.Provider,{value:t},e)}},1624:(e,a,t)=>{t.d(a,{_:()=>n});var s=t(4286),i=t(2253);const n=()=>(0,s.useContext)(i.E)},1642:(e,a,t)=>{t.d(a,{O:()=>i});var s=t(7195);const i=e=>{if(!e)return;const a=(0,s.getAbsoluteTimeRange)({from:e.from,to:e.to},{forceNow:new Date});return{from:a.from,to:a.to}}},2714:(e,a,t)=>{t.d(a,{Qi:()=>l,WA:()=>n,sh:()=>r});var s=t(770),i=t(6735);const n=async({http:e,name:a,size:t=i.Un,owners:s,signal:n})=>await e.post(i.uZ,{body:JSON.stringify({name:a,size:t,owners:s}),signal:n}),l=async({security:e,uids:a})=>{const t=a.filter((e=>!(0,s.isEmpty)(e)));return 0===t.length?[]:e.userProfiles.bulkGet({uids:new Set(t),dataPath:"avatar"})},r=async({security:e})=>e.userProfiles.getCurrent({dataPath:"avatar"})},8526:(e,a,t)=>{t.d(a,{v:()=>o});var s=t(3530),i=t(3423),n=t(3867),l=t(6990),r=t(2714);const o=()=>{const{security:e}=(0,n.o1)().services,a=(0,n.Yf)();return(0,s.useQuery)(l.Yy.currentUser(),(()=>(0,r.sh)({security:e})),{retry:!1,onError:e=>{var t;"AbortError"!==e.name&&404!==(null===(t=e.body)||void 0===t?void 0:t.statusCode)&&a.addError(e.body&&e.body.message?new Error(e.body.message):e,{title:i.a2})}})}},7808:(e,a,t)=>{t.d(a,{Vg:()=>s,Vh:()=>n,Y3:()=>i});const s=e=>!e.all&&!e.create&&!e.update&&!e.delete&&!e.push&&!e.assign&&!e.createComment&&e.read,i=["create","read","update","delete","push","assign"],n=e=>i.filter((a=>a!==e))}}]);