"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processCase = exports.isStringOrArray = exports.findCasesContainingAllDocumentsRoute = exports.findCasesContainingAllAlertsRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _pLimit = _interopRequireDefault(require("p-limit"));
var _create_cases_route = require("../create_cases_route");
var _constants = require("../../../../common/constants");
var _constants2 = require("../constants");
var _utils = require("../../../client/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// cases modal shows 10 cases by default
const MAX_CONCURRENT_CASES = 10;
const findCasesContainingAllDocumentsRoute = exports.findCasesContainingAllDocumentsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    body: _configSchema.schema.object({
      documentIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      // TODO: remove this field in the next serverless release cycle https://github.com/elastic/security-team/issues/14718
      alertIds: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
      caseIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  routerOptions: {
    access: 'internal'
  },
  handler: async ({
    context,
    request,
    response
  }) => {
    var _filterIds;
    const {
      documentIds,
      caseIds,
      alertIds
    } = request.body;

    // TODO: remove this in the next serverless release cycle https://github.com/elastic/security-team/issues/14718
    let filterIds = documentIds;
    if (!filterIds) {
      filterIds = alertIds;
    }
    if (!caseIds.length || !((_filterIds = filterIds) !== null && _filterIds !== void 0 && _filterIds.length)) {
      return response.ok({
        body: {
          casesWithAllAttachments: []
        }
      });
    }
    const caseIdsToCheck = Array.isArray(caseIds) ? caseIds : [caseIds];
    const documentIdSet = new Set(documentIds);
    const casesContext = await context.cases;
    const casesClient = await casesContext.getCasesClient();
    const limit = (0, _pLimit.default)(MAX_CONCURRENT_CASES);
    const results = await Promise.all(caseIdsToCheck.map(caseId => {
      return limit(async () => processCase(casesClient, caseId, documentIdSet));
    }));
    return response.ok({
      body: {
        casesWithAllAttachments: results.filter(id => id !== null)
      }
    });
  }
});

// TODO: remove this route in the next serverless release cycle https://github.com/elastic/security-team/issues/14718
const findCasesContainingAllAlertsRoute = exports.findCasesContainingAllAlertsRoute = (0, _create_cases_route.createCasesRoute)({
  method: 'post',
  path: _constants.INTERNAL_CASE_GET_CASES_BY_ALERTS_URL,
  security: _constants2.DEFAULT_CASES_ROUTE_SECURITY,
  params: {
    body: _configSchema.schema.object({
      documentIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      alertIds: _configSchema.schema.arrayOf(_configSchema.schema.string()),
      caseIds: _configSchema.schema.arrayOf(_configSchema.schema.string())
    })
  },
  routerOptions: {
    access: 'internal'
  },
  handler: findCasesContainingAllDocumentsRoute.handler
});
const isStringOrArray = value => {
  return typeof value === 'string' || Array.isArray(value) && value.every(item => typeof item === 'string');
};
exports.isStringOrArray = isStringOrArray;
const processCase = async (casesClient, caseId, documentIds) => {
  const documentsForCase = await casesClient.attachments.getAllDocumentsAttachedToCase({
    caseId,
    filter: (0, _utils.combineFilters)([(0, _utils.buildFilter)({
      filters: Array.from(documentIds),
      field: 'eventId',
      operator: 'or',
      type: 'cases-comments'
    }), (0, _utils.buildFilter)({
      filters: Array.from(documentIds),
      field: 'alertId',
      operator: 'or',
      type: 'cases-comments'
    })], 'or')
  });
  return documentIds.size === documentsForCase.length ? caseId : null;
};
exports.processCase = processCase;