"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompatible = isCompatible;
var _public = require("@kbn/lens-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _can_use_cases = require("../../../client/helpers/can_use_cases");
var _owner = require("../../../../common/utils/owner");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function isCompatible(embeddable, currentAppId, core) {
  var _embeddable$timeRange, _embeddable$timeRange2, _embeddable$parentApi, _embeddable$parentApi2;
  if (!(0, _public.isLensApi)(embeddable) || (0, _presentationPublishing.hasBlockingError)(embeddable)) return false;
  if (!embeddable.getFullAttributes()) {
    return false;
  }
  const timeRange = (_embeddable$timeRange = (_embeddable$timeRange2 = embeddable.timeRange$) === null || _embeddable$timeRange2 === void 0 ? void 0 : _embeddable$timeRange2.value) !== null && _embeddable$timeRange !== void 0 ? _embeddable$timeRange : embeddable.parentApi && (0, _presentationPublishing.apiPublishesTimeRange)(embeddable.parentApi) ? (_embeddable$parentApi = embeddable.parentApi) === null || _embeddable$parentApi === void 0 ? void 0 : (_embeddable$parentApi2 = _embeddable$parentApi.timeRange$) === null || _embeddable$parentApi2 === void 0 ? void 0 : _embeddable$parentApi2.value : undefined;
  if (!timeRange) {
    return false;
  }
  const owner = (0, _owner.getCaseOwnerByAppId)(currentAppId);
  const casePermissions = (0, _can_use_cases.canUseCases)(core.application.capabilities)(owner ? [owner] : undefined);
  return casePermissions.update && casePermissions.create;
}