"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createSettingsUserActionBuilder = void 0;
var _common = require("./common");
var _translations = require("./translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SETTING_CONFIGS = [{
  key: 'syncAlerts',
  enabledLabel: `${_translations.ENABLED_SETTING} ${_translations.SYNC_ALERTS_LC}`,
  disabledLabel: `${_translations.DISABLED_SETTING} ${_translations.SYNC_ALERTS_LC}`
}, {
  key: 'extractObservables',
  enabledLabel: `${_translations.ENABLED_SETTING} ${_translations.EXTRACT_OBSERVABLES_LC}`,
  disabledLabel: `${_translations.DISABLED_SETTING} ${_translations.EXTRACT_OBSERVABLES_LC}`
}];
function getSettingsLabel(userAction) {
  const settings = userAction.payload.settings;
  const labels = SETTING_CONFIGS.filter(config => settings[config.key] !== undefined).map(config => settings[config.key] ? config.enabledLabel : config.disabledLabel);

  // Join labels if multiple, or return single label
  return labels.length > 1 ? labels.join(', ') : labels[0] || '';
}
const createSettingsUserActionBuilder = ({
  userAction,
  userProfiles,
  handleOutlineComment
}) => ({
  build: () => {
    var _action$payload;
    const action = userAction;
    const {
      syncAlerts,
      extractObservables
    } = action === null || action === void 0 ? void 0 : (_action$payload = action.payload) === null || _action$payload === void 0 ? void 0 : _action$payload.settings;
    if (syncAlerts !== undefined || extractObservables !== undefined) {
      const commonBuilder = (0, _common.createCommonUpdateUserActionBuilder)({
        userProfiles,
        userAction,
        handleOutlineComment,
        label: getSettingsLabel(action),
        icon: 'gear'
      });
      return commonBuilder.build();
    }

    // if new settings are introduced. they won't be rendered
    return [];
  }
});
exports.createSettingsUserActionBuilder = createSettingsUserActionBuilder;