"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormContext = void 0;
var _react = _interopRequireDefault(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _schema = require("./schema");
var _use_get_supported_action_connectors = require("../../containers/configure/use_get_supported_action_connectors");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/create/form_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const FormContext = ({
  children,
  initialValue,
  currentConfiguration,
  selectedOwner,
  onSubmitCase
}) => {
  const {
    data: connectors = []
  } = (0, _use_get_supported_action_connectors.useGetSupportedActionConnectors)();
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: {
      /**
       * This is needed to initiate the connector
       * with the one set in the configuration
       * when creating a case.
       */
      ...(0, _utils.getInitialCaseValue)({
        owner: selectedOwner,
        connector: currentConfiguration.connector
      }),
      ...initialValue
    },
    options: {
      stripEmptyFields: false
    },
    schema: _schema.schema,
    onSubmit: onSubmitCase,
    serializer: data => (0, _utils.createFormSerializer)(connectors, {
      ...currentConfiguration,
      owner: selectedOwner
    }, data),
    deserializer: _utils.createFormDeserializer
  });
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    onKeyDown: e => {
      // It avoids the focus scaping from the flyout when enter is pressed.
      // https://github.com/elastic/kibana/issues/111120
      if (e.key === 'Enter') {
        e.stopPropagation();
      }
    },
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 5
    }
  }, children);
};
exports.FormContext = FormContext;
FormContext.displayName = 'FormContext';