"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFields = void 0;
var _reactQuery = require("@kbn/react-query");
var _use_cases_toast = require("../../../common/use_cases_toast");
var _constants = require("../constants");
var _api = require("./api");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetFields = ({
  http,
  connector
}) => {
  var _connector$id;
  const {
    showErrorToast
  } = (0, _use_cases_toast.useCasesToast)();
  return (0, _reactQuery.useQuery)(_constants.connectorsQueriesKeys.resilientGetFields((_connector$id = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id !== void 0 ? _connector$id : ''), async ({
    signal
  }) => {
    var _connector$id2;
    const fields = await (0, _api.getFields)({
      http,
      signal,
      connectorId: (_connector$id2 = connector === null || connector === void 0 ? void 0 : connector.id) !== null && _connector$id2 !== void 0 ? _connector$id2 : ''
    });

    // prepare data for EuiComboBox and create a record for easy access
    const prepared = fields.data ? fields.data.reduce((preparedData, currentField) => {
      const preparedField = {
        ...currentField,
        label: currentField.text,
        value: currentField.name
      };
      preparedData.fieldsObj[currentField.name] = preparedField;
      preparedData.fields.push(preparedField);
      return preparedData;
    }, {
      fields: [],
      fieldsObj: {}
    }) : {
      fields: [],
      fieldsObj: {}
    };
    return {
      ...fields,
      data: {
        fields: prepared.fields,
        fieldsObj: prepared.fieldsObj
      }
    };
  }, {
    enabled: Boolean(connector),
    staleTime: 60 * 1000,
    // one minute
    onSuccess: res => {
      if (res.status && res.status === 'error') {
        var _res$serviceMessage;
        showErrorToast(new Error(i18n.INCIDENT_FIELDS_API_ERROR), {
          title: i18n.INCIDENT_FIELDS_API_ERROR,
          toastMessage: `${(_res$serviceMessage = res.serviceMessage) !== null && _res$serviceMessage !== void 0 ? _res$serviceMessage : res.message}`
        });
      }
    },
    onError: error => {
      showErrorToast(error, {
        title: i18n.INCIDENT_FIELDS_API_ERROR
      });
    }
  });
};
exports.useGetFields = useGetFields;