"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdditionalFormFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _kibana = require("../../../common/lib/kibana");
var _additional_form_field = require("./additional_form_field");
var _use_get_fields = require("./use_get_fields");
var i18n = _interopRequireWildcard(require("./translations"));
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/connectors/resilient/additional_form_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AdditionalFormFields = exports.AdditionalFormFields = /*#__PURE__*/_react.default.memo(({
  connector,
  field: additionalFieldsFormField,
  isInSidebarForm
}) => {
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    isLoading: isLoadingFields,
    isFetching: isFetchingFields,
    data: fieldsData
  } = (0, _use_get_fields.useGetFields)({
    http,
    connector
  });

  // We need to filter out read-only fields and the ones that have dedicated form entries
  const options = (0, _react.useMemo)(() => {
    var _fieldsData$data;
    const fields = (fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data = fieldsData.data) === null || _fieldsData$data === void 0 ? void 0 : _fieldsData$data.fields) || [];
    return fields.reduce((acc, field) => {
      if (field.read_only !== true && field.name !== 'incident_type_ids' && field.name !== 'severity_code') {
        acc.push({
          label: field.text,
          value: field.name
        });
      }
      return acc;
    }, []);
  }, [fieldsData]);
  const [additionalFields, setAdditionalFields] = _react.default.useState(() => {
    const parsed = additionalFieldsFormField.value ? JSON.parse(additionalFieldsFormField.value) : {};
    return Object.keys(parsed).map(key => {
      var _fieldsData$data$fiel, _fieldsData$data2, _fieldsData$data2$fie;
      return {
        label: (_fieldsData$data$fiel = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data2 = fieldsData.data) === null || _fieldsData$data2 === void 0 ? void 0 : (_fieldsData$data2$fie = _fieldsData$data2.fieldsObj[key]) === null || _fieldsData$data2$fie === void 0 ? void 0 : _fieldsData$data2$fie.text) !== null && _fieldsData$data$fiel !== void 0 ? _fieldsData$data$fiel : key,
        value: key
      };
    });
  });
  const defaultAdditionalFields = (0, _react.useMemo)(() => {
    return additionalFieldsFormField.value ? JSON.parse(additionalFieldsFormField.value) : {};
  }, [additionalFieldsFormField.value]);
  const {
    form
  } = (0, _hook_form_lib.useForm)({
    defaultValue: defaultAdditionalFields,
    options: {
      stripUnsetFields: false,
      stripEmptyFields: false,
      valueChangeDebounceTime: 500
    }
  });
  const [fields] = (0, _hook_form_lib.useFormData)({
    form
  });
  const {
    isInvalid,
    errorMessage
  } = (0, _hook_form_lib.getFieldValidityAndErrorMessage)(additionalFieldsFormField);
  (0, _react.useEffect)(() => {
    var _fieldsData$data3;
    const fieldsMetadataRecord = (fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data3 = fieldsData.data) === null || _fieldsData$data3 === void 0 ? void 0 : _fieldsData$data3.fieldsObj) || {};
    const transformedFields = additionalFields.reduce((acc, field) => {
      const key = field.value;
      const value = fields[key || ''];
      if (key === undefined) {
        return acc;
      }
      const fieldMetaData = fieldsMetadataRecord[key];
      if (!fieldMetaData) {
        return acc;
      }
      acc[key] = (0, _utils.formFieldToResilientFieldValue)(value, fieldMetaData);
      return acc;
    }, {});
    const newValue = JSON.stringify(transformedFields);
    if (newValue !== additionalFieldsFormField.value) {
      if (newValue === '{}') {
        additionalFieldsFormField.setValue('');
      } else {
        additionalFieldsFormField.setValue(newValue);
      }
    }
  }, [additionalFields, additionalFieldsFormField, fields, fieldsData]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.Form, {
    form: form,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.ADDITIONAL_FIELDS_LABEL,
    helpText: i18n.ADDITIONAL_FIELDS_HELP_TEXT,
    isInvalid: isInvalid,
    error: errorMessage,
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    "data-test-subj": "resilientAdditionalFieldsComboBox",
    fullWidth: true,
    isClearable: true,
    isDisabled: isLoadingFields,
    isLoading: isFetchingFields || isLoadingFields,
    onChange: setAdditionalFields,
    options: options,
    placeholder: i18n.ADDITIONAL_FIELDS_PLACEHOLDER,
    isInvalid: isInvalid,
    selectedOptions: additionalFields,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  })), additionalFields.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 38
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: isInSidebarForm ? 1 : 3,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 7
    }
  }, additionalFields.map(field => {
    var _fieldsData$data4;
    const fieldMetaData = fieldsData === null || fieldsData === void 0 ? void 0 : (_fieldsData$data4 = fieldsData.data) === null || _fieldsData$data4 === void 0 ? void 0 : _fieldsData$data4.fieldsObj[field.value || ''];
    if (!fieldMetaData) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: fieldMetaData.name,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 145,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_additional_form_field.AdditionalFormField, {
      field: fieldMetaData,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 146,
        columnNumber: 15
      }
    }));
  })));
});
AdditionalFormFields.displayName = 'AdditionalFormFields';