"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.select = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const select = fun => (...fns) => {
  let prevId = NaN;
  let cache = null;
  const old = object => prevId === (prevId = object.primaryUpdate.payload.uid);
  return obj => old(obj) ? cache : cache = fun(...fns.map(f => f(obj)));
};
exports.select = select;