"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElementSettings = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _datasource = require("../../datasource");
var _function_form_list = require("../../function_form_list");
var _workpad_filters = require("../../workpad_filters/workpad_filters");
var _filter = require("../../../lib/filter");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/sidebar/element_settings/element_settings.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// @ts-expect-error unconverted component
// @ts-expect-error unconverted component
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const strings = {
  getDataTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.dataTabLabel', {
    defaultMessage: 'Data',
    description: 'This tab contains the settings for the data (i.e. Elasticsearch query) used as ' + 'the source for a Canvas element'
  }),
  getDisplayTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.displayTabLabel', {
    defaultMessage: 'Display',
    description: 'This tab contains the settings for how data is displayed in a Canvas element'
  }),
  getFiltersTabLabel: () => _i18n.i18n.translate('xpack.canvas.elementSettings.filtersTabLabel', {
    defaultMessage: 'Filters',
    description: 'This tab contains information about filters related to a Canvas element'
  })
};
const ElementSettings = ({
  element
}) => {
  const tabs = (0, _react.useMemo)(() => {
    const filtersTab = (0, _filter.isExpressionWithFilters)(element.expression) && {
      id: 'filters',
      name: strings.getFiltersTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 55,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_workpad_filters.WorkpadFilters, {
        element: element,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 56,
          columnNumber: 11
        }
      })),
      'data-test-subj': 'canvasSidebarFiltersTab'
    };
    return [{
      id: 'edit',
      name: strings.getDisplayTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 67,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar--args",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 68,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_function_form_list.FunctionFormList, {
        element: element,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 15
        }
      }))),
      'data-test-subj': 'canvasSidebarDisplayTab'
    }, {
      id: 'data',
      name: strings.getDataTabLabel(),
      content: /*#__PURE__*/_react.default.createElement("div", {
        className: "canvasSidebar__pop",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 79,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_datasource.Datasource, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 80,
          columnNumber: 13
        }
      })),
      'data-test-subj': 'canvasSidebarDataTab'
    }, ...(filtersTab ? [filtersTab] : [])];
  }, [element]);
  const [selectedTab, setSelectedTab] = (0, _react.useState)(tabs[0].id);
  const onSelectedTabChanged = id => {
    setSelectedTab(id);
  };
  const tabsHeaders = tabs.map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    key: tab.id,
    onClick: () => onSelectedTabChanged(tab.id),
    isSelected: tab.id === selectedTab,
    "data-test-subj": tab['data-test-subj'],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, tab.name));
  const tabsContent = (0, _react.useMemo)(() => tabs.map(({
    id,
    content
  }) => id === selectedTab ? content :
  /*#__PURE__*/
  // tabs must be hidden, but mounted, because `Display` tab, for example,
  // contains args, which should react on input changes and change the expression,
  // according to the logic they encapsulate.
  // Good example: columns have changed, the args of expression `math` should be changed, containing the new columns.
  _react.default.createElement("div", {
    style: {
      display: 'none'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, content)), [selectedTab, tabs]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 7
    }
  }, tabsHeaders), tabsContent);
};
exports.ElementSettings = ElementSettings;
ElementSettings.propTypes = {
  // @ts-expect-error upgrade typescript v5.9.3
  element: _propTypes.default.object
};