"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleGetStateVariables = handleGetStateVariables;
var _output_parsers = require("@langchain/core/output_parsers");
var _constants = require("./constants");
var _prompts = require("./prompts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleGetStateVariables({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const celStateGraph = _prompts.CEL_STATE_PROMPT.pipe(model).pipe(outputParser);
  const celState = await celStateGraph.invoke({
    cel_program: state.currentProgram,
    ex_answer: _constants.EX_ANSWER_STATE
  });

  // Return all state vars besides the URL as it gets included automatically
  const filteredState = celState.filter(stateVar => stateVar !== 'url');
  return {
    stateVarNames: filteredState,
    lastExecutedChain: 'getStateVars'
  };
}