"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getUnprocessedOtelErrors = getUnprocessedOtelErrors;
var _utils = require("@kbn/apm-data-access-plugin/server/utils");
var _server = require("@kbn/observability-plugin/server");
var _apm = require("../../../common/es_fields/apm");
var _as_mutable_array = require("../../../common/utils/as_mutable_array");
var _compact_map = require("../../utils/compact_map");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const requiredOtelFields = (0, _as_mutable_array.asMutableArray)([_apm.SPAN_ID, _apm.ID, _apm.SERVICE_NAME, _apm.AT_TIMESTAMP]);
const optionalOtelFields = (0, _as_mutable_array.asMutableArray)([_apm.EXCEPTION_TYPE, _apm.EXCEPTION_MESSAGE, _apm.OTEL_EVENT_NAME, _apm.TIMESTAMP_US]);
async function getUnprocessedOtelErrors({
  logsClient,
  traceId,
  docId,
  start,
  end
}) {
  const response = await logsClient.search({
    query: {
      bool: {
        filter: [...(0, _server.rangeQuery)(start, end), ...(0, _server.termQuery)(_apm.TRACE_ID, traceId), ...(0, _server.termQuery)(_apm.SPAN_ID, docId)],
        should: [...(0, _server.termQuery)(_apm.OTEL_EVENT_NAME, 'exception'), ...(0, _server.existsQuery)(_apm.EXCEPTION_TYPE), ...(0, _server.existsQuery)(_apm.EXCEPTION_MESSAGE)],
        minimum_should_match: 1,
        must_not: {
          exists: {
            field: _apm.PROCESSOR_EVENT
          }
        }
      }
    },
    fields: [...requiredOtelFields, ...optionalOtelFields]
  });
  return (0, _compact_map.compactMap)(response.hits.hits, hit => {
    var _event$TIMESTAMP_US;
    const event = hit.fields ? (0, _utils.accessKnownApmEventFields)(hit.fields).requireFields(requiredOtelFields) : undefined;
    if (!event) return null;
    const timestamp = (_event$TIMESTAMP_US = event[_apm.TIMESTAMP_US]) !== null && _event$TIMESTAMP_US !== void 0 ? _event$TIMESTAMP_US : new Date(event[_apm.AT_TIMESTAMP]).getTime() * 1000;
    const error = {
      id: event[_apm.ID],
      span: {
        id: event[_apm.SPAN_ID]
      },
      trace: {
        id: traceId
      },
      timestamp: {
        us: timestamp
      },
      eventName: event[_apm.OTEL_EVENT_NAME],
      service: {
        name: event[_apm.SERVICE_NAME]
      },
      error: {
        exception: {
          type: event[_apm.EXCEPTION_TYPE],
          message: event[_apm.EXCEPTION_MESSAGE]
        }
      }
    };
    return error;
  });
}