"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getStorageDetails = getStorageDetails;
var _get_storage_details_per_service = require("./get_storage_details_per_service");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getStorageDetails({
  apmEventClient,
  context,
  indexLifecyclePhase,
  randomSampler,
  environment,
  kuery,
  start,
  end,
  serviceName
}) {
  const [processorEventStats, indicesStats] = await Promise.all([(0, _get_storage_details_per_service.getStorageDetailsPerProcessorEvent)({
    apmEventClient,
    context,
    indexLifecyclePhase,
    randomSampler,
    environment,
    kuery,
    start,
    end,
    serviceName
  }), (0, _get_storage_details_per_service.getStorageDetailsPerIndex)({
    apmEventClient,
    context,
    indexLifecyclePhase,
    randomSampler,
    environment,
    kuery,
    start,
    end,
    serviceName
  })]);
  return {
    processorEventStats,
    indicesStats
  };
}