"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingPluginSetting = useProfilingPluginSetting;
exports.useTransactionProfilingSetting = useTransactionProfilingSetting;
var _common = require("@kbn/observability-plugin/common");
var _use_apm_plugin_context = require("../context/apm_plugin/use_apm_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingPluginSetting() {
  var _core$application$cap;
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  return Boolean((_core$application$cap = core.application.capabilities.profiling) === null || _core$application$cap === void 0 ? void 0 : _core$application$cap.show);
}
function useTransactionProfilingSetting() {
  const {
    core
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const isProfilingPluginEnabled = useProfilingPluginSetting();
  const isTransactionProfilingEnabled = core.uiSettings.get(_common.apmEnableTransactionProfiling);
  return isProfilingPluginEnabled && isTransactionProfilingEnabled;
}