"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionsTable = TransactionsTable;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uuid = require("uuid");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/observability-plugin/common");
var _document_type = require("../../../../common/document_type");
var _latency_aggregation_types = require("../../../../common/latency_aggregation_types");
var _use_apm_service_context = require("../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../hooks/use_apm_params");
var _use_apm_router = require("../../../hooks/use_apm_router");
var _use_breakpoints = require("../../../hooks/use_breakpoints");
var _use_debounce = require("../../../hooks/use_debounce");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _use_preferred_data_source_and_bucket_size = require("../../../hooks/use_preferred_data_source_and_bucket_size");
var _transaction_overview_link = require("../links/apm/transaction_overview_link");
var _managed_table = require("../managed_table");
var _overview_table_container = require("../overview_table_container");
var _get_comparison_options = require("../time_comparison/get_comparison_options");
var _get_columns = require("./get_columns");
var _use_apm_plugin_context = require("../../../context/apm_plugin/use_apm_plugin_context");
var _get_comparison_enabled = require("../time_comparison/get_comparison_enabled");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/transactions_table/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const INITIAL_STATE = {
  requestId: '',
  transactionGroups: [],
  maxCountExceeded: false,
  transactionOverflowCount: 0,
  hasActiveAlerts: false
};
function TransactionsTable({
  fixedHeight = false,
  hideViewTransactionsLink = false,
  hideTitle = false,
  numberOfTransactionsPerPage = 10,
  showPerPageOptions = true,
  showMaxTransactionGroupsExceededWarning = false,
  environment,
  kuery,
  start,
  end,
  saveTableOptionsToUrl = false,
  onLoadTable,
  showSparkPlots
}) {
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const {
    core,
    observabilityAIAssistant
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const [renderedItems, setRenderedItems] = (0, _react.useState)([]);
  const {
    query,
    query: {
      comparisonEnabled,
      offset,
      latencyAggregationType: latencyAggregationTypeFromQuery
    }
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions', '/services/{serviceName}/overview', '/mobile-services/{serviceName}/transactions', '/mobile-services/{serviceName}/overview', '/services/{serviceName}/transactions/view');
  const latencyAggregationType = (0, _latency_aggregation_types.getLatencyAggregationType)(latencyAggregationTypeFromQuery);
  const defaultComparisonEnabled = (0, _get_comparison_enabled.getComparisonEnabled)({
    core,
    urlComparisonEnabled: comparisonEnabled
  });
  const {
    isLarge
  } = (0, _use_breakpoints.useBreakpoints)();
  const shouldShowSparkPlots = showSparkPlots !== null && showSparkPlots !== void 0 ? showSparkPlots : !isLarge;
  const {
    transactionType,
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const [searchQuery, setSearchQueryDebounced] = (0, _use_debounce.useStateDebounced)('');
  const {
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  } = useTableData({
    comparisonEnabled,
    end,
    environment,
    kuery,
    latencyAggregationType,
    offset,
    searchQuery,
    serviceName,
    start,
    transactionType,
    renderedItems
  });
  (0, _react.useEffect)(() => {
    if ((0, _use_fetcher.isSuccess)(mainStatisticsStatus) && (0, _use_fetcher.isSuccess)(detailedStatisticsStatus)) {
      onLoadTable === null || onLoadTable === void 0 ? void 0 : onLoadTable();
    }
  }, [mainStatisticsStatus, detailedStatisticsStatus, onLoadTable, end, start]);
  const columns = (0, _react.useMemo)(() => {
    return (0, _get_columns.getColumns)({
      serviceName,
      latencyAggregationType: latencyAggregationType,
      detailedStatisticsLoading: (0, _use_fetcher.isPending)(detailedStatisticsStatus),
      detailedStatistics,
      comparisonEnabled: defaultComparisonEnabled,
      shouldShowSparkPlots,
      offset,
      transactionOverflowCount: mainStatistics.transactionOverflowCount,
      showAlertsColumn: mainStatistics.hasActiveAlerts,
      link,
      query
    });
  }, [defaultComparisonEnabled, detailedStatistics, detailedStatisticsStatus, latencyAggregationType, link, mainStatistics.hasActiveAlerts, mainStatistics.transactionOverflowCount, offset, query, serviceName, shouldShowSparkPlots]);
  const setScreenContext = observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.service.setScreenContext;
  const isTableSearchBarEnabled = core.uiSettings.get(_common.apmEnableTableSearchBar, true);
  const tableSearchBar = (0, _react.useMemo)(() => {
    return {
      isEnabled: isTableSearchBarEnabled,
      fieldsToSearch: ['name'],
      maxCountExceeded: mainStatistics.maxCountExceeded,
      onChangeSearchQuery: setSearchQueryDebounced,
      placeholder: _i18n.i18n.translate('xpack.apm.transactionsTable.tableSearch.placeholder', {
        defaultMessage: 'Search transactions by name'
      })
    };
  }, [isTableSearchBarEnabled, mainStatistics.maxCountExceeded, setSearchQueryDebounced]);
  (0, _react.useEffect)(() => {
    return setScreenContext === null || setScreenContext === void 0 ? void 0 : setScreenContext({
      data: [{
        name: 'top_transactions',
        description: 'The visible transaction groups',
        value: mainStatistics.transactionGroups.map(group => {
          return {
            name: group.name,
            alertsCount: group.alertsCount
          };
        })
      }]
    });
  }, [setScreenContext, mainStatistics]);
  const title = _i18n.i18n.translate('xpack.apm.transactionsTable.title', {
    defaultMessage: 'Transactions'
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    "data-test-subj": "transactionsGroupTable",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 190,
      columnNumber: 5
    }
  }, !hideTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 193,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 196,
      columnNumber: 17
    }
  }, title))), !hideViewTransactionsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 200,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_transaction_overview_link.TransactionOverviewLink, {
    serviceName: serviceName,
    latencyAggregationType: latencyAggregationType,
    transactionType: transactionType,
    query: query,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.transactionsTable.linkText', {
    defaultMessage: 'View transactions'
  }))))), showMaxTransactionGroupsExceededWarning && mainStatistics.maxCountExceeded && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 218,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    title: _i18n.i18n.translate('xpack.apm.transactionsCallout.cardinalityWarning.title', {
      defaultMessage: 'Number of transaction groups exceed the allowed maximum(1,000) that are displayed.'
    }),
    color: "warning",
    iconType: "warning",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 228,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.transactionsCallout.transactionGroupLimit.exceeded",
    defaultMessage: "The maximum number of transaction groups displayed in Kibana has been reached. Try narrowing down results by using the query bar.",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 229,
      columnNumber: 15
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_overview_table_container.OverviewTableContainer, {
    fixedHeight: fixedHeight,
    isEmptyAndNotInitiated: mainStatistics.transactionGroups.length === 0 && mainStatisticsStatus === _use_fetcher.FETCH_STATUS.NOT_INITIATED,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 238,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_managed_table.ManagedTable, {
    noItemsMessage: mainStatisticsStatus === _use_fetcher.FETCH_STATUS.LOADING ? _i18n.i18n.translate('xpack.apm.transactionsTable.loading', {
      defaultMessage: 'Loading...'
    }) : _i18n.i18n.translate('xpack.apm.transactionsTable.noResults', {
      defaultMessage: 'No transactions found'
    }),
    items: mainStatistics.transactionGroups,
    columns: columns,
    initialSortField: "impact",
    initialSortDirection: "desc",
    initialPageSize: numberOfTransactionsPerPage,
    isLoading: mainStatisticsStatus === _use_fetcher.FETCH_STATUS.LOADING,
    tableSearchBar: tableSearchBar,
    showPerPageOptions: showPerPageOptions,
    saveTableOptionsToUrl: saveTableOptionsToUrl,
    onChangeRenderedItems: setRenderedItems,
    tableCaption: title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 245,
      columnNumber: 11
    }
  }))));
}
function useTableData({
  comparisonEnabled,
  end,
  environment,
  kuery,
  latencyAggregationType,
  offset,
  searchQuery,
  serviceName,
  start,
  transactionType,
  renderedItems
}) {
  var _preferredDataSource$;
  const preferredDataSource = (0, _use_preferred_data_source_and_bucket_size.usePreferredDataSourceAndBucketSize)({
    start,
    end,
    kuery,
    numBuckets: 20,
    type: _document_type.ApmDocumentType.TransactionMetric
  });
  const shouldUseDurationSummary = latencyAggregationType === 'avg' && (preferredDataSource === null || preferredDataSource === void 0 ? void 0 : (_preferredDataSource$ = preferredDataSource.source) === null || _preferredDataSource$ === void 0 ? void 0 : _preferredDataSource$.hasDurationSummaryField);
  const {
    data: mainStatistics = INITIAL_STATE,
    status: mainStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!latencyAggregationType || !transactionType || !preferredDataSource) {
      return Promise.resolve(undefined);
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/transactions/groups/main_statistics', {
      params: {
        path: {
          serviceName
        },
        query: {
          environment,
          kuery,
          start,
          end,
          transactionType,
          useDurationSummary: !!shouldUseDurationSummary,
          latencyAggregationType: latencyAggregationType,
          documentType: preferredDataSource.source.documentType,
          rollupInterval: preferredDataSource.source.rollupInterval,
          searchQuery
        }
      }
    }).then(mainStatisticsData => {
      return {
        requestId: (0, _uuid.v4)(),
        ...mainStatisticsData
      };
    });
  }, [searchQuery, end, environment, kuery, latencyAggregationType, preferredDataSource, serviceName, shouldUseDurationSummary, start, transactionType]);
  const itemsToFetch = (0, _react.useMemo)(() => renderedItems.map(({
    name
  }) => name), [renderedItems]);
  const {
    data: detailedStatistics,
    status: detailedStatisticsStatus
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (start && end && transactionType && latencyAggregationType && preferredDataSource && itemsToFetch.length > 0) {
      return callApmApi('GET /internal/apm/services/{serviceName}/transactions/groups/detailed_statistics', {
        params: {
          path: {
            serviceName
          },
          query: {
            environment,
            kuery,
            start,
            end,
            bucketSizeInSeconds: preferredDataSource.bucketSizeInSeconds,
            transactionType,
            documentType: preferredDataSource.source.documentType,
            rollupInterval: preferredDataSource.source.rollupInterval,
            useDurationSummary: !!shouldUseDurationSummary,
            latencyAggregationType: latencyAggregationType,
            transactionNames: JSON.stringify(itemsToFetch),
            offset: comparisonEnabled && (0, _get_comparison_options.isTimeComparison)(offset) ? offset : undefined
          }
        }
      });
    }
  },
  // only fetches detailed statistics when `currentPageItems` is updated.

  // eslint-disable-next-line react-hooks/exhaustive-deps
  [mainStatistics.requestId, itemsToFetch, offset, comparisonEnabled], {
    preservePreviousData: false
  });
  return {
    mainStatistics,
    mainStatisticsStatus,
    detailedStatistics,
    detailedStatisticsStatus
  };
}