"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SparkPlot = SparkPlot;
exports.SparkPlotItem = SparkPlotItem;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _style = require("../../../../utils/style");
var _get_comparison_chart_theme = require("../../time_comparison/get_comparison_chart_theme");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/spark_plot/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function hasValidTimeseries(series) {
  return !!(series !== null && series !== void 0 && series.some(point => point.y !== null));
}
const flexGroupStyle = {
  overflow: 'hidden'
};
function SparkPlot({
  type = 'line',
  color,
  isLoading,
  series,
  comparisonSeries = [],
  valueLabel,
  compact,
  comparisonSeriesColor
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "xs",
    responsive: false,
    alignItems: "flexEnd",
    style: flexGroupStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, valueLabel), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 63,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(SparkPlotItem, {
    type: type,
    color: color,
    isLoading: isLoading,
    series: series,
    comparisonSeries: comparisonSeries,
    comparisonSeriesColor: comparisonSeriesColor,
    compact: compact,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  })));
}
function SparkPlotItem({
  type,
  color,
  isLoading,
  series,
  comparisonSeries,
  comparisonSeriesColor,
  compact
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const defaultChartThemes = (0, _public.useChartThemes)();
  const comparisonChartTheme = (0, _get_comparison_chart_theme.getComparisonChartTheme)();
  const hasComparisonSeries = !!(comparisonSeries !== null && comparisonSeries !== void 0 && comparisonSeries.length);
  const sparkplotChartTheme = {
    chartMargins: {
      left: 0,
      right: 0,
      top: 0,
      bottom: 0
    },
    lineSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    areaSeriesStyle: {
      point: {
        opacity: 0
      }
    },
    ...(hasComparisonSeries ? comparisonChartTheme : {})
  };
  const chartSize = {
    height: euiTheme.size.l,
    width: compact ? _style.unit * 4 : _style.unit * 5
  };
  if (isLoading) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        ...chartSize,
        display: 'flex',
        alignItems: 'center',
        justifyContent: 'center'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 9
      }
    }));
  }
  if (hasValidTimeseries(series)) {
    return /*#__PURE__*/_react.default.createElement(_charts.Chart, {
      size: chartSize,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
      theme: [sparkplotChartTheme, ...defaultChartThemes.theme],
      baseTheme: defaultChartThemes.baseTheme,
      showLegend: false,
      locale: _i18n.i18n.getLocale(),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }), /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
      type: "none",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 9
      }
    }), type && type === 'bar' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: "barSeries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: "x",
      yAccessors: ['y'],
      data: series,
      color: color,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 13
      }
    }), hasComparisonSeries && /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
      id: "comparisonBarSeries",
      xScaleType: _charts.ScaleType.Linear,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: comparisonSeries,
      color: comparisonSeriesColor,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 153,
        columnNumber: 15
      }
    })) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
      id: "Sparkline"
      // Defaults to multi layer time axis as of Elastic Charts v70
      ,
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: series,
      color: color,
      curve: _charts.CurveType.CURVE_MONOTONE_X,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 13
      }
    }), hasComparisonSeries && /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
      id: "comparisonSeries"
      // Defaults to multi layer time axis as of Elastic Charts v70
      ,
      xScaleType: _charts.ScaleType.Time,
      yScaleType: _charts.ScaleType.Linear,
      xAccessor: 'x',
      yAccessors: ['y'],
      data: comparisonSeries,
      color: comparisonSeriesColor,
      curve: _charts.CurveType.CURVE_MONOTONE_X,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 15
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      ...chartSize,
      display: 'flex',
      alignItems: 'center',
      justifyContent: 'center'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 197,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "visLine",
    color: euiTheme.colors.mediumShade,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 205,
      columnNumber: 7
    }
  }));
}