"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDebugSettings = getDebugSettings;
var _i18n = require("@kbn/i18n");
var _utils = require("../settings_form/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getDebugSettings() {
  return [{
    key: 'expvar_enabled',
    type: 'boolean',
    labelAppend: _utils.OPTIONAL_LABEL,
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.expvarEnabledTitle', {
      defaultMessage: 'Enable APM Server Golang expvar support'
    }),
    rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.expvarEnabledDescription', {
      defaultMessage: 'Exposed under /debug/vars'
    })
  }, {
    key: 'pprof_enabled',
    type: 'boolean',
    labelAppend: _utils.OPTIONAL_LABEL,
    rowTitle: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.pprofEnabledTitle', {
      defaultMessage: 'Enable APM Server pprof support'
    }),
    rowDescription: _i18n.i18n.translate('xpack.apm.fleet_integration.settings.debug.pprofEnabledDescription', {
      defaultMessage: 'Expose HTTP endpoints to retrieve profiling data'
    })
  }];
}