"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AgentKeyCallOut = AgentKeyCallOut;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1767096202385903533/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/settings/agent_keys/create_agent_key/agent_key_callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function AgentKeyCallOut({
  name,
  token
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.title', {
      defaultMessage: 'Created "{name}" key',
      values: {
        name
      }
    }),
    color: "success",
    iconType: "check",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 28,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.message', {
    defaultMessage: 'Copy this key now. You will not be able to view it again.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFieldPassword, {
    "data-test-subj": "apmAgentKeyCallOutFieldText",
    type: "dual",
    readOnly: true,
    value: token,
    "aria-label": _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.agentKeyLabel', {
      defaultMessage: 'APM agent key'
    }),
    prepend: "Base64",
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
      textToCopy: token,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 46,
        columnNumber: 13
      }
    }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "apmAgentKeyCallOutButton",
      iconType: "copyClipboard",
      onClick: copy,
      color: "success",
      style: {
        backgroundColor: 'transparent'
      },
      "aria-label": _i18n.i18n.translate('xpack.apm.settings.agentKeys.copyAgentKeyField.copyButton', {
        defaultMessage: 'Copy to clipboard'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 17
      }
    })),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 7
    }
  }));
}